namespace eval ::apache1.3:: {}

proc ::apache1.3::parseBrowserMatch {text parser dirDef xmlConf currentContainer} {
    set elements [::apacheparserutils::getElements $text]
    switch [set directive [string tolower [lindex $elements 0]]] {
       browsermatch {
          set case case
       } browsermatchnocase {
          set case nocase
       } default {
	   error "unknown directive [lindex $elements 0] "
       }
    }
    set xuiObj [apacheparserutils::getOrCreateIfNotExists browserMatch \
            $dirDef $xmlConf $currentContainer]
    set child [$xuiObj newChild]
    $xuiObj insertChild $child
    #puts "Elements $elements"
    #puts "1: [lindex $elements 1]"
    [$child getComponentByName case] selectItem $case
    [$child getComponentByName string] setValue [lindex $elements 1]
    [$child getComponentByName variable] setValue [lrange $elements 2 end]
}

proc ::apache1.3::dumpBrowserMatch { xuiObj } {
    set result {}
    foreach child [$xuiObj getChildren] {
    switch [[$child getComponentByName case] getSelected] {
        case { 
	    append result {BrowserMatch }
	} nocase {
	    append result {BrowserMatchNoCase }
	}
    }
    append result "[[$child getComponentByName string] getValue] "
    append result "[[$child getComponentByName variable] getValue]\n"
    }
    return $result
}


