namespace eval ::apache1.3:: {}

proc ::apache1.3::parseClearModuleList \
	{elements parser dirDef xmlConf currentContainer} {
    set value [lindex $elements 1]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists clearModuleList \
	    $dirDef $xmlConf $currentContainer]
    $xuiObj  setValue
}

proc ::apache1.3::dumpClearModuleList { xuiObj } {
    if [$xuiObj getValue] {
        return "ClearModuleList\n"
    } else {
        return
    }
}

proc ::apache1.3::parseBindAddress \
	{elements parser dirDef xmlConf currentContainer} {
    set value [lindex $elements 1]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists bindAddress \
	    $dirDef $xmlConf $currentContainer]
    switch $value {
	* {
	    $xuiObj  selectComponentByName allAddresses
	} default {
	    $xuiObj  selectComponentByName specific
	    [$xuiObj getComponentByName specific] setValue $value
	}
    }
}

proc ::apache1.3::dumpBindAddress { xuiObj } {
    switch [$xuiObj getSelectedComponentName] {
	allAddresses {
	    #BindAddress * is the default, so we do not return it
	    #return "bindaddress *\n"
	    return {}
	} default {
	    return "BindAddress [$xuiObj getText]\n"
	}
    }
}


proc ::apache1.3::parseErrorLog \
	{elements parser dirDef xmlConf currentContainer} {
    set value [lindex $elements 1]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists errorLog \
	    $dirDef $xmlConf $currentContainer]
    if [regexp syslog $value] {
	$xuiObj selectComponentByName syslog
	[$xuiObj getComponentByName syslog] setValue \
		[lindex [split $value :] 1]
    } else {
	$xuiObj selectComponentByName file
	[$xuiObj getComponentByName file] setValue $value
    }
    
}

proc ::apache1.3::dumpErrorLog { xuiObj } {
    switch [$xuiObj getSelectedComponentName] {
	syslog {
	    set result "ErrorLog syslog"
            if [string length [set value \
		    [[$xuiObj getComponentByName syslog] getValue]]] {
		append result ":[[$xuiObj getComponentByName syslog] getValue]"
	    }
	    append result "\n"
	    return $result
	} default {
	    set value [$xuiObj.file getValue]
	    if [expr [llength $value] && \
	              [string compare $value [$xuiObj.file getDefault]]] {
	       return "ErrorLog $value\n"
	    } else {
	       return {}
	    }
	}
    }
}


proc ::apache1.3::parseAddModule \
        {text parser dirDef xmlConf currentContainer} {
    set elements [::apacheparserutils::getElements $text]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists addModule \
    $dirDef $xmlConf $currentContainer]
    foreach index [lrange $elements 1 end ] {
        set newElement [ $xuiObj newChild ]
	$xuiObj insertChild $newElement
	$newElement setValue $index
    }
}
					    
proc ::apache1.3::dumpAddModule { xuiObj } {
    if [llength [set children [ $xuiObj getChildren ]]] {
	    foreach child [ $xuiObj getChildren ] {
	            append result "AddModule [$child getValue]\n"
	    }
	        return $result
	    } else {
	    return 
	    }
}	    


proc ::apache1.3::parseOptions \
        {text parser dirDef xmlConf currentContainer} {  
    set elements [::apacheparserutils::getElements $text]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists options \
    $dirDef $xmlConf $currentContainer]    
    set list [$xuiObj getComponentByName rules]
    [$xuiObj getComponentByName merge] setValue
    foreach element [lrange $elements 1 end] {
        if ![string compare none [string tolower $element]] break
	set child [$list newChild]
	$list insertChild $child
	switch -- [string index $element 0] {
	    + {
		[$child getComponentByName action] selectItem enable
		[$child getComponentByName option] selectItem \
		        [string tolower [string range $element 1 end]]
	    } - {
		[$child getComponentByName action] selectItem disable
		[$child getComponentByName option] selectItem \
		        [string tolower [string range $element 1 end]]
	    } default {
		[$xuiObj getComponentByName merge] clearValue
		[$child getComponentByName action] selectItem enable
		[$child getComponentByName option] selectItem \
		        [string tolower $element]
	    }
	}
    }

}







proc ::apache1.3::dumpOptions {xuiObj} {
    set mergeFlag [[$xuiObj getComponentByName merge] getValue]
    set list [$xuiObj getComponentByName rules]
    if ![llength [set children [$list getChildren]]] {
        return
    }
    set result {Options }
    foreach child $children {
        append result { }
        switch [[$child getComponentByName action] getSelected] {
	    enable {
	       if $mergeFlag {
	           append result +
	       }
	    } disable {
	       if $mergeFlag {
	           append result -  
	       } else {
	       
	       # If we are not merging, we do not need - (unsure)

	           break
	       }
	    }
	}
	append result "[[$child getComponentByName option] getSelected] "
    }
    append result \n
    return $result
}




proc ::apache1.3::parseRequire {elements parser dirDef xmlConf currentContainer} {
    set xuiObj [apacheparserutils::getOrCreateIfNotExists require \
            $dirDef $xmlConf $currentContainer]
    set type [lindex $elements 1]
    switch $type {
       valid-user {
           [$xuiObj getComponentByName validUser] setValue
	} user - group {
           set list [$xuiObj getComponentByName ${type}s]
           foreach item [lrange $elements 2 end] {
               set newElement [$list newChild]
               $list insertChild $newElement
               $newElement setValue $item
	    }
	 } default {
           error
	}
     }
  }
      
proc ::apache1.3::dumpRequire {xuiObj} {
   set result {}
    if [ [$xuiObj getComponentByName validUser] getValue] {
        append result "Require valid-user\n"
     }
    set list [[$xuiObj getComponentByName users] getChildren]
    if [llength $list] {
        append result "Require user "
        foreach element $list {
            append result [$element getValue]
	 }
       append result "\n"
    }
    set list [[$xuiObj getComponentByName groups] getChildren]
    if [llength $list] {
        append result "Require group "
        foreach element $list {
            append result [$element getValue]
            append result " "
	 }
        append result "\n"
     }
    return $result
}
 
 
                  
