namespace eval ::apache1.3:: {}

proc ::apache1.3::parseLoadModule {text parser dirDef xmlConf currentContainer} {
    set elements [::apacheparserutils::getElements $text]
    set xuiObj [apacheparserutils::getOrCreateIfNotExists loadModule \
            $dirDef $xmlConf $currentContainer]
    set child [$xuiObj newChild]
    $xuiObj insertChild $child
    [$child getComponentByName name ] setValue [lindex $elements 1]
    [$child getComponentByName filename ] setValue [lindex $elements 2]
}

proc ::apache1.3::dumpLoadModule { xuiObj } {
    if ![llength [ $xuiObj getChildren ]] {return}
    set result {}
    foreach child [ $xuiObj getChildren ] {
        append result "LoadModule "
	append result "[[$child getComponentByName name] getValue] "
	append result "[[$child getComponentByName filename] getValue]\n "
    }
    return $result
}


