
class ::apacheInstallConfig {
    variable xuiDoc
    variable configFile
    variable guiB
    variable dialog
    constructor { propertyPages confFile } {
    set f [open $propertyPages]
    set xuiDoc [::xuiB renderDocument [::dom::DOMImplementation \
        parse [read $f]]]
    close $f
    set configFile $confFile
    set guiB [guiBuilder ::#auto]
    set dialog [ apacheInstallDialog ::#auto $guiB ]
    }
    method configure {  }
    method save
    method load {  }
    method clear
}

body apacheInstallConfig::configure { } {
    $this load
    set exitCode [$dialog show $xuiDoc]
    switch $exitCode {
	OK {
	    $this save
	}
	CANCEL {
	    # todo: show warning saying that if no Apache installation is specified, 
	    # it will (surprise) not be possible to configura Apache
	}
    }

   # load
   
   # Create top level
   
   
   
   # Show gui
   # When done, save results if OK
}

body apacheInstallConfig::clear {} {

}

# TO-DO: clean up all this mess. It may be eaier to use the same XML 
# format in file and in the xui and just do copyClone

body apacheInstallConfig::load {} {
    $this clear
    if [file exists $configFile] {
        set f [open $configFile]
	set apacheConf [::dom::DOMImplementation parse [read $f]]
	close $f
    } else {
	return
    }
    set servers [::dom::getElements [dom::getElements $apacheConf]]
    foreach serverElement $servers {
	set xuiServer [$xuiDoc newChild]
	set serverDescription [::dom::getAttribute $serverElement name]
	[$xuiServer getComponentByName comment] setValue $serverDescription
	set commandList [$xuiServer getComponentByName commands]
	$commandList clear
        foreach infoElement [::dom::getElements $serverElement] {
	    switch [::dom::getTagName $infoElement] {
		command {
		    set newCommand [$commandList newChild] 
		    [$newCommand getComponentByName name] setValue \
			    [::dom::getAttribute $infoElement name] 
		    [$newCommand getComponentByName command] setValue \
			    [::dom::getText $infoElement]
		    [$newCommand getComponentByName icon] setValue \
			    [::dom::getAttribute $infoElement icon]
		    $commandList insertChild $newCommand
		} httpd {
		    set httpd [::dom::getText $infoElement]
		    [$xuiServer getComponentByName httpd] \
			    setValue $httpd
		} configurationFiles {
		    set configurationFiles [::dom::getText $infoElement]
		    [$xuiServer getComponentByName httpdconf] \
			    setValue $configurationFiles
		} serverRoot {
		    set serverRoot [::dom::getText $infoElement]
		    [$xuiServer getComponentByName serverroot] \
			    setValue $serverRoot
		}
	    }
	}
	$xuiDoc insertChild $xuiServer
    }
}
    
    
# XXX change this mess to do it with the DOM API

body apacheInstallConfig::save {} {

    # This is so if in the first time they pressed cancel no config file
    # is created, so next time it will get asked for configuration again

    if ![llength [$xuiDoc getChildren]] {
        file delete $configFile
	return
    }
    set f [open $configFile w]
    puts $f "<apacheModuleConf>"
    foreach xuiServer [$xuiDoc getChildren] {
        puts -nonewline $f "<server name=\""
	puts -nonewline $f [[$xuiServer getComponentByName comment] getValue]
	puts $f "\">"
	puts -nonewline $f "<httpd>"
	puts -nonewline $f [[$xuiServer getComponentByName httpd] getValue]
	puts $f "</httpd>"
	puts -nonewline $f "<configurationFiles>"
	puts -nonewline $f [[$xuiServer getComponentByName httpdconf] getValue]
	puts $f "</configurationFiles>"
	puts -nonewline $f "<serverRoot>"
	puts -nonewline $f [[$xuiServer getComponentByName serverroot] getValue]
	puts $f "</serverRoot>"
	set commandList [$xuiServer getComponentByName commands]
        foreach command [$commandList getChildren] {
	        puts -nonewline $f "<command name=\""
		puts -nonewline $f \
		    [[$command getComponentByName name] getValue]
		puts -nonewline $f "\" icon=\""
		puts -nonewline $f \
		    [[$command getComponentByName icon] getValue]
		puts -nonewline $f "\">"
		puts -nonewline $f \
		    [[$command getComponentByName command] getValue]
		puts $f "</command>"    
	}
	puts $f "</server>"
    }
    puts $f "</apacheModuleConf>"
    close $f
}
    
    






