# apmanagerPlugIn --
#
# Manages Apache plugIns installations

class apmanagerPlugIn {
    inherit plugIn

    # This variable contains property page

    variable apmanagerPP
    variable apmanagerNodeId
    variable _callerId

    # xxx Redundancy

    variable installationsConfigMapping    
    variable installationsConfigDir
    variable installationsDescriptionMapping
    constructor {} {
	#set apmanagerXuiPP [::libgui::createXuiFromFile $::apmanager::pp]
	set apmanagerPP(newInstallationWizard) [::libgui::createXuiFromFile $::apmanager::pp(newInstallationWizard)]
	set apmanagerPP(deleteInstallationWizard) [::libgui::createXuiFromFile $::apmanager::pp(deleteInstallationWizard)]
	set f [open $apmanager::distributionsLayoutsFile]
	set text [read $f]
	close $f
	set doc [dom::getElements [dom::DOMImplementation parse $text]]
	foreach distribution [dom::getElements $doc] {
	    array set ::apmanager::distributionsLayouts \
		    [list [dom::getAttribute $distribution name] \
		    [dom::getElements $distribution]]
	}
	array set installationsConfigMapping {}	
	array set installationsDescriptionMapping {}
    }
    method init { args }
    method _saveSettings { node text filename}
    method _inquiryForRightPaneContent { node docInfo }
    method _inquiryForMenu { node docInfo }
    method _inquiryForPropertyPages { node docInfo }
    method _inquiryForWizard { node docInfo }
    method _receivedWizard { node docInfo propertyPageList }
    method _receivedPropertyPages { node docInfo propertyPageList }
    method _submitCommand 
    method _addInstallation {configDirectory}
    method newInstallation {xmlDescription}
    method loadInstallationsIntoPage {xuiPage}
    method deleteInstallation {plugIn}
    method restartInstallation {plugIn}
}



# args contains the options that are passed to the plugIn at initialization
# time.
#
#  -namespace    contains the name of the name space server
    

body apmanagerPlugIn::init {args} {
    array set options $args
    set namespace $options(-namespace)
    set _callerId [$namespace registerPlugIn $this]
    set apmanagerNodeId [$namespace addNode root \
        [list -classList {apmanager container} \
	-openImage tipi.gif \
	-closedImage tipi.gif \
	-text [mesg::get resolv_apmanager_settings]] $_callerId] 
    source ../plugins/apache/init.tcl 

   
    global tcl_platform 
    switch $tcl_platform(platform) {
	windows {
	    apache_init -namespace ::ns -moduledirectory ../plugins/apache \
		    -backupsdir \
		    $apmanager::apacheManagerConfigurationDirectory/windows/backups \
		    -hookUnderNode $apmanagerNodeId -apmanager $this
 	} default {
	    foreach dir [glob -nocomplain [file join $apmanager::apacheManagerConfigurationDirectory *]] {
	if ![string compare [file tail $dir] windows] {
	    # Skip windows
	} else {
	    _addInstallation $dir
	}
    }
      }
    }
}

body apmanagerPlugIn::_submitCommand {configDirectory} {
}

body apmanagerPlugIn::_addInstallation {configDirectory} {
    set confFile [file join $configDirectory apache.conf]
    if [string match [file tail $configDirectory] CVS] {
	return
    }
    if ![catch {apache_init -namespace ::ns -moduledirectory ../plugins/apache \
	    -apachePlugInConfig $confFile -backupsdir $configDirectory/backups -hookUnderNode $apmanagerNodeId -apmanager $this} data] {
	set plugIn [lindex $data 0]	
	set text [lindex $data 1]
	array set installationsConfigMapping [list $plugIn $confFile]	
	array set installationsConfigDir [list $plugIn $configDirectory]	
	array set installationsDescriptionMapping [list $plugIn $text]    
    } else {
	puts "Error trying to add Apache installation $confFile: $data"
	#global errorInfo
	#puts $errorInfo
    }
}

body apmanagerPlugIn::_inquiryForRightPaneContent { node docInfo } {
    global tcl_platform
    set result {<img src="apache_logo.gif">}
    append result "<h1>[mesg::get resolv_apmanager_right_pane_title]</h1>"
    global tcl_platform
    switch $tcl_platform(platform) {
	windows {
	    append result [mesg::get resolv_apmanager_right_pane_windows]
	} default {
	    append result [mesg::get resolv_apmanager_right_pane]
	    append result {<br><img src="smallWheel.gif">}
	    append result \
		    [comanche::html::createShowWizardURL $node \
		    {New Apache Installation} newapacheinstallation tag]
	    if [array size installationsConfigMapping] {
		append result {<br><img src="smallWheel.gif">}
		append result \
			[comanche::html::createShowWizardURL $node \
			{Delete Apache Installation} deleteapacheinstallation tag]
	    }
	}
    }
    return $result
}  

body apmanagerPlugIn::_inquiryForMenu { node docInfo } {     
    
    #   return [list  [list -type command -label "Configure" -command [comanche::html::createShowPropertyPagesURL $node {} notag]]]
    set state disabled
    if [array size installationsDescriptionMapping] {
	set state normal
    }
    global tcl_platform
    switch $tcl_platform(platform) {
	windows {
	    return {}
	} default {
	    return [list \
		    [list -type command -label "Add Apache Installation" -command \
		    [comanche::html::createShowWizardURL $node {New Apache Installation} newapacheinstallation notag]] \
		    [list -type command -label "Delete Apache Installation" -command \
		    [comanche::html::createShowWizardURL $node {Delete Apache Installation} deleteapacheinstallation notag] \
		    -state $state] \
		    ]
	}
    }
    #	    [list -type command -label "Modify Apache Installation" -command \
	    [comanche::html::createShowWizardURL $node {Modify Apache Installation} modifyapacheinstallation notag] \
	    -state $state]  \

}

body apmanagerPlugIn::_inquiryForPropertyPages  { node docInfo } {
    global tcl_platform
    #fillPropertyPages
    if [file readable $::apmanager::apacheManagerConfigurationDirectory/1/apache.conf] {
        set doc [dom::newDoc $::apmanager::apacheManagerConfigurationDirectory/1/apache.conf]
        ::globalXuiBuilder loadValueFromNode $doc $apmanagerPP()
    }
    return $apmanagerPP(
}      

body apmanagerPlugIn::_inquiryForWizard {node docInfo} {
    array set documentInfo $docInfo
    switch $documentInfo(documentSubtype) {
	newapacheinstallation {
	    set selectedPageName newApacheInstallation1
	    set documentInfo(selectedPageName) $selectedPageName
	    return [list [array get documentInfo] \
		    $apmanagerPP(newInstallationWizard)]
	} deleteapacheinstallation {
	    set selectedPageName deleteApacheInstallation1
	    loadInstallationsIntoPage [plugInUtils::getPageByName \
 		    $selectedPageName $apmanagerPP(deleteInstallationWizard)]
	    set documentInfo(selectedPageName) $selectedPageName
	    return [list [array get documentInfo] \
		    $apmanagerPP(deleteInstallationWizard)]
	} modifyapacheinstallation {
	} default {
	    puts "Unknown wizard document type $documentSubtype"
	}
    }    
}

body apmanagerPlugIn::_receivedWizard { node docInfo propertyPageList } {
    array set documentInfo $docInfo
    switch $documentInfo(documentSubtype) {
	newapacheinstallation {
	    set data [::apmanager::apmanagerWizard $this $documentInfo(selectedPageName) \
		    $documentInfo(pageEvent) $propertyPageList]
	} deleteapacheinstallation {
	    set data [::apmanager::apmanagerWizardDelete $this $documentInfo(selectedPageName) \
		    $documentInfo(pageEvent) $propertyPageList]
	} default {
	    error "Unrecognized subtype $documentInfo(documentSubtype)"
	}
    }
    switch [lindex $data 0] {
	page {
	    set nextPage [lindex $data 1]
	    array set documentInfo [list selectedPageName $nextPage]
	    return [list ok [list [array get documentInfo] $propertyPageList]]
	} default {
	    return $data
	}
    }
}

body apmanagerPlugIn::_receivedPropertyPages { node documentInfo propertyPageList } {
    set pp [lindex $propertyPageList 0]
    set doc [dom::newDoc]
    set installation [comanche::serialize::xuiObj2XML $pp.apacheServerInstallation $doc]
    set result [dom::DOMImplementation serialize $installation]
    dom::deleteDoc $doc
    _saveSettings $node $result $::apmanager::apacheManagerConfigurationDirectory/1/apache.conf
    #saveapmanagerettings $pp
}

body apmanagerPlugIn::_saveSettings {node text filename} {
    set f [open $filename w]
    puts $f $text
    close $f
}

body apmanagerPlugIn::loadInstallationsIntoPage {xuiPage} {
    $xuiPage.installations clear
    foreach {plugIn description} [array get installationsDescriptionMapping] {
	$xuiPage.installations addChoice $plugIn $description
    }
}


# apmanagerPlugIn::newInstallation --
#
# Create the configuration files and directories 
# used by Comanche to administer Apache installations.

body apmanagerPlugIn::newInstallation {xmlDefinition} {
    set index 1
    set directory [file join \
	    $::apmanager::apacheManagerConfigurationDirectory $index] 
    while {[file exists $directory]} {
	incr index
	set directory [file join \
		$::apmanager::apacheManagerConfigurationDirectory $index] 	
    }
    file mkdir $directory
    file mkdir $directory/backups
    set f [open [file join $directory apache.conf ] w]
    puts $f $xmlDefinition
    close $f
    _addInstallation $directory
}


body apmanagerPlugIn::restartInstallation {plugIn} {
    $plugIn die

	#xxx only will work with one installation
    global tcl_platform 
    switch $tcl_platform(platform) {
	windows {
	    apache_init -namespace ::ns -moduledirectory ../plugins/apache \
		    -backupsdir \
		    $apmanager::apacheManagerConfigurationDirectory/windows/backups \
		    -hookUnderNode $apmanagerNodeId -apmanager $this
} default {
    _addInstallation $installationsConfigDir($plugIn)
}
}
}

body apmanagerPlugIn::deleteInstallation {plugIn} {
    #delete 
    $plugIn die
    file delete -force [file dirname $installationsConfigMapping($plugIn)]
    unset installationsConfigMapping($plugIn)
    unset installationsConfigDir($plugIn)
    unset installationsDescriptionMapping($plugIn)
}
