# apmanagerWizard.tcl --
#
# Wizard functions for adding / removing installations

namespace eval ::apmanager:: {}

proc ::apmanager::apmanagerWizard {apmanagerPlugIn selectedPageName event pageList} {
    array set page { newApacheInstallation1-next newApacheInstallation2 \
	    newApacheInstallation2-next newApacheInstallation3 \
	    newApacheInstallation2-prev newApacheInstallation1 \
	    newApacheInstallation3-prev newApacheInstallation2 }
    switch -- $selectedPageName-$event {
	newApacheInstallation2-next {
	    set propertyPage [plugInUtils::getPageByName $selectedPageName $pageList]
	    switch [$propertyPage.apacheSelection getSelectedComponentName] {
		compiled {
		    set directory [$propertyPage.apacheSelection.compiled getValue]
		    set xuiConfig [newXuiApacheInstallation]
		    if [file exists [file join $directory bin/httpsd]] {
			set binary httpsd 
			set apachectl httpsdctl
		    } else {
			set binary httpd
			set apachectl apachectl
		    }
		    foreach {field value} [list httpd bin/$binary \
			    httpdconf conf/$binary.conf \
			    serverroot {} \
			    libexec libexec] {
			$xuiConfig.$field setValue [file join $directory $value]
		    }
		    set descriptionPage [plugInUtils::getPageByName newApacheInstallation1 $pageList]
		    $xuiConfig.comment setValue [$descriptionPage.description getValue]
		    $xuiConfig.commands clear
		    foreach function {Start Stop Restart} {
			set xuiCommand [$xuiConfig.commands newChild]
			$xuiCommand.name setValue $function
			$xuiCommand.command setValue \
				"[file join $directory bin/$apachectl] [string tolower $function]"
			$xuiCommand.icon setValue [string tolower $function].gif
			$xuiConfig.commands insertChild $xuiCommand
		    }
		} 
		distribution {
		    set dist [$propertyPage.apacheSelection.distribution getSelected]
		    set xuiConfig [newXuiApacheInstallation]
		    ::globalXuiBuilder loadValueFromNode \
			    $apmanager::distributionsLayouts($dist) $xuiConfig 

		} 
		custom {
		    return {page newApacheInstallation3}
		}
	    }
	    if [catch {checkInstallationIsSane $xuiConfig} text] {
		delete object $xuiConfig		
		return [list error $text]
	    }
	    $apmanagerPlugIn newInstallation [comanche::serialize::getXmlTextFromXui $xuiConfig]
	    delete object $xuiConfig
	    return {page newApacheInstallationEnd}
	} newApacheInstallation3-next {

	    # Todo: Check all parameters are ok

	    set xuiConfig [newXuiApacheInstallation]
	    set propertyPage [plugInUtils::getPageByName $selectedPageName $pageList]
	    foreach parameter {httpd httpdconf serverroot libexec} {
		$xuiConfig.$parameter setValue \
			[$propertyPage.apacheServerInstallation.$parameter getValue]  
	    }
	    set descriptionPage [plugInUtils::getPageByName newApacheInstallation1 $pageList]
	    $xuiConfig.comment setValue [$descriptionPage.description getValue]
	    if [catch {checkInstallationIsSane $xuiConfig} text] {
		delete object $xuiConfig		
		return [list error $text]
	    }
	    $apmanagerPlugIn newInstallation [comanche::serialize::getXmlTextFromXui $xuiConfig]
	    delete object $xuiConfig
	    return {page newApacheInstallationEnd}
	} newApacheInstallationEnd-next {
	    return [list ok {}]
	}
	default {
	    return [list page $page($selectedPageName-$event)]
	}
    }
}



proc ::apmanager::apmanagerWizardDelete {apmanagerPlugIn selectedPageName event pageList} {
    switch -- $selectedPageName-$event {
	deleteApacheInstallation1-next {
	    set xuiPage [plugInUtils::getPageByName deleteApacheInstallation1 $pageList]
	    $apmanagerPlugIn deleteInstallation [$xuiPage.installations getSelected]
	    return {ok {}}
	}
    }
}

proc ::apmanager::newXuiApacheInstallation {} {
    return [::libgui::createXuiFromFile $::apmanager::installationXMLPrototype]
}

# ::apmanager::isInstallationSane --
#
#    Check parameters are ok (directories exist and have the 
# right permissions, etc.)

proc ::apmanager::checkInstallationIsSane {xuiObject} {
    foreach element {{httpd file executable} \
	    {httpdconf file writable}  \
	    {serverroot directory readable} \
	    {libexec directory readable} } {
	set field [lindex $element 0]
	set fileType [lindex $element 1]
	set condition [lindex $element 2]
	set path [$xuiObject.$field getValue]
	if ![ file is$fileType $path] {
	    if [file exists $path] {
		error "[comanche::capitalize $fileType] $path\n is not a $filetype"
	    } else {
		error "[comanche::capitalize $fileType] $path\ndoes not exist"
	    }
	} elseif ![file $condition $path] {
	    error "[comanche::capitalize $fileType] $path\nis not $condition by current user" 
	}
    }
}