
# This is a template file to help you create your own plugins

# Determine my current directory

set currentDir [file dirname [file join [pwd] [info script]]]

# Process messages catalogs

catch {::mesg::processMesgCatalogDir [file join $currentDir messages]}

# Create our own namespace and save the location of any relevant files for
# future use by plugin instances. In this case we are saving the location
# of the XML description of a property page

namespace eval ::apmanager:: {
    array set pp {}
    variable installationXMLPrototype
    variable apacheManagerConfigurationDirectory
    variable distributionsLayoutsFile
    variable distributionsLayouts
}
source [file join $currentDir apmanager.tcl]
source [file join $currentDir backup.tcl]
source [file join $currentDir apmanagerWizard.tcl]

set ::apmanager::installationXMLPrototype [file join $currentDir pp.xml]
set ::apmanager::distributionsLayoutsFile [file join $currentDir layouts.xml]
set ::apmanager::pp(newInstallationWizard) [file join $currentDir newInstallationWizard.xml]
set ::apmanager::pp(deleteInstallationWizard) [file join $currentDir deleteApacheInstallationWizard.xml]
set ::apmanager::apacheManagerConfigurationDirectory [file join $currentDir configurations]

# Convention: Create init function with the name of your plugin_init 

proc apmanager_init { args } {
    array set options $args
    [apmanagerPlugIn ::#auto] init -namespace $options(-namespace) \
         -moduledirectory $options(-moduledirectory)
}

# Some data about your plugin

proc apmanager_info {} {
     array set info [list description [mesg::get apmanager_description]]
     array set info {name {apmanager}}
     array set info {version {1.0}}
     array set info {icon tipi.gif}
     return [array get info]
}
		    
		    
		                 


