# manager.tcl --

# managerPlugIn --
#   Collects and displays information about installed plugins such as name,
# version, description. 
#
# It is also responsoble for creating the big categories
#
# TO-DO: When the plugin API is more advanced, provide functionality to 
# load/unload plugins on demand.

class managerPlugIn {
    inherit plugIn
    variable managerXuiPP
    variable managerEntry    
    variable managerNodeId
    variable networkServicesNodeId
    variable systemNodeId
    variable modulesInfo
    constructor {} {
      array set modulesInfo {}
      set managerXuiPP [xuiPropertyPage ::#auto]
      $managerXuiPP configure -icon moduleManager
      $managerXuiPP setLabel [mesg::get plugin_manager]
      $managerXuiPP setName managerPP
      set managerEntry [xuiString ::#auto]
      $managerEntry setLabel "manager"      
      $managerEntry setName manager
      $managerXuiPP addComponent $managerEntry 
    }
    method init { args }
    method _inquiryForRightPaneContent { node docInfo}
    method _inquiryForPropertyPages { node docInfo}
    method _receivedPropertyPages { node docInfo propertyPageList}
}



# args contains the options that are passed to the plugIn at initialization
# time.
#
#  -namespace    contains the name of the name space server
    

body managerPlugIn::init {args} {

    # We are hooking to the root node
    # The ::plugInUtils::addNode syntaxis is the following
    # ::plugInUtils::addNode caller namespace parentNode
    # where
    # caller: Name of the object that is adding the node (the plugIn object)
    # namespace: Namespace where we are adding the node
    # parentNode: Parent node
    #
    # The list of available icons is in view/images.tcl    

    array set options $args
    set namespace $options(-namespace)
    set parentNode root
#    set managerNodeId [::plugInUtils::addNode $this $namespace $parentNode \
        -classes {manager leaf} \
	-openImage moduleManager \
	-closedImage moduleManager \
	-text [mesg::get plugin_management] ]
#    set networkServices [::plugInUtils::addNode $this $namespace $parentNode \
        -classes {networkServices container} \
	-openImage network \
	-closedImage network \
	-label [mesg::get network_services] ]
#    set system [::plugInUtils::addNode $this $namespace $parentNode \
        -classes {system container} \
	-openImage smallWheel \
	-closedImage smallWheel \
	-label [mesg::get System]]
#    set systemNodeId [$system getId]
#    set managerNodeId [$managerNode getId]
    
    # Now we iterate over all modules, keeping track of the options, for 
    # further display.
    # Get all module directories.

    set moduleDir $options(-moduledirectory)
    set directoryList [glob [file join $moduleDir .. *]]
    
    # Somebody with a Mac can tell me if the above works?
    
    # Load all modules.

    foreach  directory $directoryList {
        set rootname [file tail [file rootname $directory ]]
        switch $rootname {
	    manager - CVS - test - apache - hostname - samba - hostname -  resolv - tail - apache {
	        # Do nothing, it is us! :)
		# also in development, we do not want CVS
	    } default {
		set myfile [file join $directory init.tcl]
		if [file exists $myfile] {
		    source $myfile
		    splash::add "Loading [file tail $directory]"
		    ${rootname}_init -namespace $namespace \
			    -moduledirectory $directory
		    
		    # (TO-DO) Move this into registerPlugInProperties
		    # (for plugIns written in other languages)
		    
		    set modulesInfo($rootname) [${rootname}_info]
		}
	    }
	}
    }
}

body managerPlugIn::_inquiryForRightPaneContent { node docInfo } {
    switch $node [ list $managerNodeId {
    set result [mesg::get manager_right_pane]
    foreach {module info} [array get modulesInfo] {
       catch {unset infoArray}
       array set infoArray $info
       append result "<br><img src=\"$infoArray(icon)\">"
       append result "<b>$infoArray(name) - $infoArray(version)</b>"
       append result "<hr>"
       append result $infoArray(description)
       append result "<br>"
    }
    } default {
       set result {}
    }    ]
    return $result
}  

set comment {


#    {} $systemNodeId {
#         set result [mesg::get system_right_pane]
#    } $networkServicesNodeId   {
#    set result [mesg::get network_services__right_pane]
#    }



}

body managerPlugIn::_inquiryForPropertyPages  { node docInfo} {
    return
    if ![string compare $node $managerNodeId ] {
        return $managerXuiPP
    } else {
        return
    }
}      


body managerPlugIn::_receivedPropertyPages { node docInfo xuiPropertyPages } {
#  set pp [$xuiPropertyPages getComponentByName managerPP]
#  set newmanager [[$pp getComponentByName manager] getValue]
#  catch {exec manager $newmanager}
}
