

source ../xuibuilder/unique.tcl

namespace eval comanche::serialize {
}

proc comanche::serialize::xuiObj2List {xuiObject} {
    switch [$xuiObject getXuiClass] {
        number - string - choice - boolean {
            return [simpleXuiObj2List $xuiObject]
        } list {
            return [xuiList2List $xuiObject]
        } structure {
            return [xuiStructure2List $xuiObject]
        } alternate {
            return [xuiAlternate2List $xuiObject]
        }
    }
}

proc comanche::serialize::simpleXuiObj2List {xuiObject} {
    switch [$xuiObject getXuiClass] {
        number - string - choice - boolean {
            return [$xuiObject getValue]
        } default {
            error "Tried to serialize object of type [$xuiObject getXuiClass] with simple method."
        }
    } 
}

proc comanche::serialize::xuiList2List {xuiList} {
    set result {}
    foreach child [$xuiList getChildren] {
        lappend result [comanche::serialize::simpleXuiObj2List $child]
    }
    return $result
}

proc comanche::serialize::xuiStructure2List {xuiStructure} {
    set result {}
    foreach element [$xuiStructure getComponents] {
        lappend result [$element getName] [xuiObj2List $element]
    }
    return $result
}

proc comanche::serialize::xuiAlternate2List {xuiAlternate} {
   set result {}
   set element [$xuiAlternate getSelectedComponent]
   return [list [$element getName] [xuiObj2List $element]]
}

