
package require http


namespace eval ::comanche::html {
}


proc ::comanche::html::encodeURL {args} {
        return [eval http::formatQuery $args]
}

proc ::comanche::html::decodeURL {url} {
        return [url::decodeQuery $url]
}
         
proc comanche::html::createURL { optionList text {type tag}} {
     switch $type {
	tag {
	   return "<a href=\"[eval comanche::html::encodeURL $optionList]\">$text</a>"
	} notag {
	   return [eval comanche::html::encodeURL $optionList]
	} default {
	   error "Unknown $type type"
	}
     }
}

# to-do support override skillLevel, etc
proc comanche::html::createShowPropertyPagesURL {node text {type tag}} {
    return [createURL [list _action documentRequest _documentSubtype {} _documentType propertyPages _skillLevel basic _node $node] $text $type]
}

proc comanche::html::createShowWizardURL {node text subtype {type tag}} {
    return [createURL [list _action documentRequest _documentSubtype $subtype _documentType wizard _skillLevel basic _node $node] $text $type]
}

proc comanche::html::createShowPropertyPagesWithSelectedPageURL {node text selectedPageName {type tag}} {
    return [createURL [list _action documentRequest _documentSubtype {} _documentType propertyPages _skillLevel basic _node $node _selectedPropertyPageName $selectedPageName] $text $type]
}


proc comanche::html::createShowWizardWithEventURL {node text selectedPageName subtype event {type tag}} {
    return [createURL [list _action documentResponse _documentSubtype $subtype _documentType wizard _skillLevel basic _node $node _selectedPageName $selectedPageName _pageEvent $event] $text $type]
}

proc comanche::html::createSelectNodeURL {node text {type tag}} {
   return [createURL [list _action selectNode _node $node] $text $type]
}

proc comanche::html::createCommandURL {node text commandName {type tag}} {
   return [createURL [list _action documentRequest _node $node _documentType command _documentSubtype $commandName] $text $type]
}


