/* ====================================================================
 * Copyright (c) 1999-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@lisanza.net
 * This file contains generated code of SMASH also created by Harrie.
 *
 */

#include <stdio.h>

#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"

#include "mod_snmp.h"

int		ap_bucket_errno;
#if defined USE_DB || USE_DB2
WwwDocTopN	record_data;
#endif

/*
 * FUNCTION
 * BD_BUCKET ap_bucket_open:
 *      Function that opens a bucket in order to implement
 *      the wwwDcoumentsGroup.
 *      Returns the bucket when succesfull otherwise NULL.
 * INPUT
 * char *name:
 *      A human-readable string to identify the bucket.
 */ 
BUCKET_DB
ap_bucket_open(char *name)
{
BUCKET_DB	bucket;

#ifdef USE_DB
    unlink(name);
    bucket = dbopen(name, (O_CREAT | O_RDWR), 0664, DB_HASH, NULL);
    ap_bucket_errno = errno;
#elif USE_DB2
    int	result;

    result = db_open(name, DB_HASH, (O_CREAT | O_RDWR), 0664, NULL, NULL, bucket);
    ap_bucket_errno = errno;
    if (result) {
	return(NULL);
    }
#elif USE_DBM
#elif USE_NDBM
#endif
    return(bucket);
}


/*
 * FUNCTION
 * void ap_bucket_close:
 *      Function that close a bucket used to implement
 *      the wwwDcoumentsGroup.
 * INPUT
 * BUCKET_DB bucket:
 *      The bucket to be closed.
 */
void
ap_bucket_close(BUCKET_DB bucket)
{
    if (!bucket) return;
#ifdef USE_DB
    (bucket->close)(bucket);
#elif USE_DB2
    (bucket->close)(bucket, 0);
#elif USE_DBM
#elif USE_NDBM
#endif
}

/*
 * FUNCTION
 * WwwDocTopN *ap_bucket_fetch:
 *      Function that fetches the record associated with the key
 *      from the bucket.
 *      Returns when succesfull the record otherwise NULL.
 * INPUT
 * BUCKET_DB bucket:
 *      The bucket from which the record will be fetched.
 * char *keystr:
 *      The key of the record that needs to be fetched.
 */
WwwDocTopN *
ap_bucket_fetch(BUCKET_DB bucket, char *keystr)  
{
#ifdef USE_DB
    DBT	key;
    DBT	data;

    if (bucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	if (!((bucket->get)(bucket, &key, &data, 0))) {
	    if (data.size == sizeof(record_data)) {
		memcpy(&record_data, data.data, sizeof(WwwDocTopN));
		return(&record_data);
	    }
	}
	ap_bucket_errno = errno;
    }
#elif USE_DB2
    DBT			key;
    DBT			data;

    if (bucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	data.data = record;
	data.size = sizeof(record);
	if (!((bucket->get)(bucket, &key, &data, 0))) {
	    return record;
	}
	ap_bucket_errno = errno;
    }
#elif USE_DBM
#elif USE_NDBM
#endif
    return(NULL);
}

/*
 * FUNCTION
 * WwwDocTopN *ap_bucket_store:
 *      Function that stores a record associated with the key
 *      from the bucket.
 *      Returns when succesfull the record otherwise NULL.
 * INPUT
 * BUCKET_DB bucket:
 *      The bucket from which the record will be fetched.
 * char *keystr:
 *      The key of the record that needs to be fetched.
 */
int
ap_bucket_store(BUCKET_DB bucket, char *keystr, WwwDocTopN *record,
	int action)
{
int result = 0;
#ifdef USE_DB
    DBT	key;
    DBT	data;

    if (bucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	data.data = record;
	data.size = sizeof(WwwDocTopN);
	result = (bucket->put)(bucket, &key, &data, action);
	ap_bucket_errno = errno;
    }
#elif USE_DB2
    DBT	key;
    DBT	record;

    if (bucket) {
	key.data = keystr;
	key.size = strlen(keystr);
	record.data = record;
	record.size = sizeof(WwwDocTopN);
	result = (bucket->put)(bucket, &key, &data, action);
	ap_bucket_errno = errno;
    }
#elif USE_DBM
#elif USE_NDBM
#endif
    return(result);
}

WwwDocTopN *
ap_bucket_seqfetch(BUCKET_DB bucket, int action)
{
#ifdef USE_DB
DBT	key;
DBT	record;

    if (bucket) {
	if ((bucket->seq)(bucket, &key, &record, action) == 0) {
	    if (record.size == sizeof(record_data)) {
		memcpy(&record_data, record.data, record.size);
		return(&record_data);
	    }
	}
    }
#elif USE_DB2
#elif USE_DBM
#elif USE_NDBM
#endif
    return(NULL);
}


const char *
ap_bucket_strerror()
{
#ifdef USE_DB
     return(strerror(ap_bucket_errno));
#elif USE_DB2
     return("");
#elif USE_DBM
#elif USE_NDBM
#endif
}

