/* ====================================================================
 * Copyright (c) 1999-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@mod-snmp.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 */

/* General includes */
#include <stdio.h>

/* Apache includes */
#include <httpd.h>
#include <http_conf_globals.h>
#include <scoreboard.h>

/* SNMP includes */
#include "asn1.h"
#include "snmp.h"
#include "agt_mib.h"
#include "agt_engine.h"
#include "snmpv2-mib.h"
#include "config-mib.h"


void
init_APACHE_CONFIG_MIB()
{
#ifdef APACHE_CONFIG_GROUP
    ap_sync_scoreboard_image();
    ap_scoreboard_image->global.keep_alive = 0;
    ap_scoreboard_image->global.keep_alive_requests = 0;
    ap_scoreboard_image->global.keep_alive_timeout = 0;
    ap_scoreboard_image->global.hostname_lookup = 0;
    ap_scoreboard_image->global.log_level = 0;

    ap_scoreboard_image->global.ap_extended_status = ap_extended_status;
    ap_scoreboard_image->global.ap_max_requests_per_child = ap_max_requests_per_child;
    ap_scoreboard_image->global.ap_daemons_limit = ap_daemons_limit;
    ap_scoreboard_image->global.ap_daemons_min_free = ap_daemons_min_free;
    ap_scoreboard_image->global.ap_daemons_max_free = ap_daemons_max_free;
    register_subtrees_of_APACHE_CONFIG_MIB();
    /* insert the Object Resource in sysORTable */
    { static struct sysOREntry_struct value = { NULL, 1, {8, {O_apacheConfigMIB}}, "The Apache Config MIB module", 0};
      insert_sysOREntry(&value);
    } 
#endif
}

#ifdef APACHE_CONFIG_GROUP
/*
The configExtendedStatus provides a mean to switch 
the extended status logging in the scoreboard.

This variable could be used to reduce the load
when it is turned off.
*/
int	write_configExtendedStatus(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
int	size;

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_INTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
	size = 4;
	asn_parse_int(var_val, &size, &var_val_type,
			(long *)&ap_extended_status,
			sizeof (ap_extended_status));
	break;
    case COMMIT:
	if (ap_extended_status != 1 && ap_extended_status != 2) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	ap_scoreboard_image->global.ap_extended_status = ap_extended_status - 1;
	break;
    case FREE:
	break;
    default:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configExtendedStatus(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    *write_method = write_configExtendedStatus;
    long_return = ap_scoreboard_image->global.ap_extended_status + 1;
    *var_len = sizeof(long_return);
    return (unsigned char *) &(long_return);
}

/* The configKeepAliveSwitch enables/disables the
 * persistent connections.
 */
int	write_configKeepAliveSwitch(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configKeepAliveSwitch(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    *write_method = write_configKeepAliveSwitch;
    long_return = ap_scoreboard_image->global.keep_alive + 1;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The maximum number of requests the apache server will
 * serve via 1 persistent connection.
 * If 'configKeepAlive is disabled only 1 request
 * per connection will be served.
 * 
 * Server performance can be gained if this value is 
 * kept high.
 */
int	write_configKeepAliveRequests(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configKeepAliveRequests(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    /* *write_method = write_configKeepAliveRequests; */
    long_return = ap_scoreboard_image->global.keep_alive_requests;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The number of seconds the Apache server will wait
 * for a subsequent request before closing the connection.
 * 
 * If 'configKeepAlive' is disabled the connection will
 * be terminated directly after serving the 
 * first request.
 */
int	write_configKeepAliveTimeout(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configKeepAliveTimeout(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    /* *write_method = write_configKeepAliveTimeout; */
    long_return = ap_scoreboard_image->global.keep_alive_timeout;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The configMaxServers sets the limit on the number of simultaneous
 * requests that can be supported; not more than this number
 * of child server processes will be created.
 * The maximum number is limited by the implementation, 
 * the value 'HARD_SERVER_LIMIT'
 * 
 * Any connection attempts over the limit will
 * normally be queued, up to a number based on the
 * ListenBacklog directive.
 */
int	write_configMaxServers(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
int	size;

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_INTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
	size = 4;
	if (NULL == asn_parse_int(var_val, &size, &var_val_type,
			(long *)&ap_daemons_limit,
			sizeof (ap_daemons_limit))) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break;
    case COMMIT:
	if ((ap_daemons_limit < 1) ||
		(ap_daemons_limit > HARD_SERVER_LIMIT)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	ap_scoreboard_image->global.ap_daemons_limit = ap_daemons_limit;
	break;
    case FREE:
	break;
    default:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configMaxServers(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    *write_method = write_configMaxServers;
    long_return = ap_scoreboard_image->global.ap_daemons_limit;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The configMinSpareServers sets the desired minimum number of
 * idle child server processes. An idle process is one which is
 * not handling a request. If there are fewer than
 * MinSpareServers idle, then the parent process creates new
 * children at a maximum rate of 1 per second.
 * 
 * Tuning of this parameter should only be necessary on
 * very busy sites. Setting this parameter to a large number
 * is almost always a bad idea.
 * 
 * This variable has no effect on Microsoft Windows. 
 */
int	write_configMinSpareServers(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
int	size;

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_INTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
	size = 4;
	if (NULL == asn_parse_int(var_val, &size, &var_val_type,
			(long *)&ap_daemons_min_free,
			sizeof (ap_daemons_min_free))) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break;
    case COMMIT:
	if ((ap_daemons_min_free < 1) ||
		(ap_daemons_min_free > ap_daemons_max_free)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	ap_scoreboard_image->global.ap_daemons_min_free = ap_daemons_min_free;
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configMinSpareServers(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    *write_method = write_configMinSpareServers;
    long_return = ap_scoreboard_image->global.ap_daemons_min_free;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The configMaxSpareServers sets the desired maximum number
 * of idle child server processes. An idle process is one
 * which is not handling a request. If there are more than
 * MaxSpareServers idle, then the parent process will kill
 * off the excess processes.
 * 
 * Tuning of this parameter should only be necessary on
 * very busy sites. Setting this parameter to a large
 * number is almost always a bad idea.
 * 
 * This variable has no effect when used with the Apache
 * Web server on a Microsoft Windo
 */
int	write_configMaxSpareServers(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
int	size;

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_INTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
	size = 4;
	if (NULL == asn_parse_int(var_val, &size, &var_val_type,
			(long *)&ap_daemons_max_free,
			sizeof (ap_daemons_max_free))) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break;
    case COMMIT:
	if ((ap_daemons_max_free < 1) ||
		(ap_daemons_max_free < ap_daemons_min_free) ||
		(ap_daemons_max_free > ap_daemons_limit)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	ap_scoreboard_image->global.ap_daemons_max_free = ap_daemons_max_free;
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configMaxSpareServers(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    *write_method = write_configMaxSpareServers;
    long_return = ap_scoreboard_image->global.ap_daemons_max_free;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* The MaxRequestsPerChild directive sets the limit on
 * the number of requests that an individual child server
 * process will handle.
 * After configMaxRequestsPerChild requests, the child process
 * will die. If MaxRequestsPerChild is 0, then the process
 * will never expire.
 * 
 * Setting configMaxRequestsPerChild to a non-zero limit has
 * two beneficial effects: 
 * 
 * it limits the amount of memory that process can
 * consume by (accidental) memory leakage; 
 * by giving processes a finite lifetime, it 
 */
int	write_configMaxRequestsPerChild(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configMaxRequestsPerChild(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    /* *write_method = write_configMaxRequestsPerServer; */
    long_return = ap_scoreboard_image->global.ap_max_requests_per_child;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* This variable enables DNS lookups so that host names can
 * be logged (and passed to CGIs/SSIs in REMOTE_HOST).
 * on: A forward lookup will be done to acquire the hostname.
 * off: No forward lookup will be done.
 * double: A double DNS lookup will be done. First the reverse 
 * lookup will be done and on tat result a forward
 * lookup will be done and at least one of the ip
 * addresses in the forward lookup must match the
 * original address. (In 'tcpwrapper' terminology
 * this is called PARANOID.)
 */
int	write_configHostNameLookup(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configHostNameLookup(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    /* *write_method = write_configHostNameLookup; */
    long_return = ap_scoreboard_image->global.hostname_lookup;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}

/* LogLevel adjusts the verbosity of the messages recorded
 * in the error logs.
 * The following levels are available, in order of
 * decreasing significance: 
 * emerg: Emergencies - system is unusable. 
 * 'Child cannot open lock file. Exiting'
 * alert: Action must be taken immediately. 
 * 'getpwuid: couldn't determine user name from uid'
 * crit: Critical Conditions. 
 * 'socket: Failed to get a socket, exiting child'
 * error: Error conditions. 
 * 'Premature end of script headers'
 * warn: Warning
 */
int	write_configLogLevel(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case CHECK:
	break;
    case COMMIT:
	break;
    case FREE:
	break;
    }
    return(SNMP_ERROR_NOERROR);
}

unsigned char *
var_configLogLevel(int *var_len, snmp_info_t *mesg,
        int (**write_method)(int, unsigned char *, unsigned char, int,
		unsigned char *, oid *, int))
{
    ap_sync_scoreboard_image();
    /* *write_method = write_configLogLevel; */
    long_return = ap_scoreboard_image->global.log_level;
    *var_len = sizeof(long);
    return (unsigned char *) &(long_return);
}


static oid configMIBObjects_oid[] = { O_configMIBObjects };
static Object configMIBObjects_variables[] = {
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configExtendedStatus,
                 {2, { I_configExtendedStatus, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configKeepAliveSwitch,
                 {2, { I_configKeepAliveSwitch, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configKeepAliveRequests,
                 {2, { I_configKeepAliveRequests, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configKeepAliveTimeout,
                 {2, { I_configKeepAliveTimeout, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configMaxServers,
                 {2, { I_configMaxServers, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configMinSpareServers,
                 {2, { I_configMinSpareServers, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configMaxSpareServers,
                 {2, { I_configMaxSpareServers, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configMaxRequestsPerChild,
                 {2, { I_configMaxRequestsPerChild, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configHostNameLookup,
                 {2, { I_configHostNameLookup, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_configLogLevel,
                 {2, { I_configLogLevel, 0 }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree configMIBObjects_tree =  { NULL, configMIBObjects_variables,
	        (sizeof(configMIBObjects_oid)/sizeof(oid)), configMIBObjects_oid};

/* This is the MIB registration function. This should be called */
/* within the init_APACHE_CONFIG_MIB-function */
void register_subtrees_of_APACHE_CONFIG_MIB()
{
    insert_group_in_mib(&configMIBObjects_tree);
}

#endif
