/* ====================================================================
 * Copyright (c) 1997-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@mod-snmp.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 *
 */

#ifndef _MOD_SNMP_H_
#define _MOD_SNMP_H_

/* SNMP required definitions */
#define SNMP_AGT_VERSION "SNMP module 1.3.6.11"

#define DEFAULT_COMM "public"


/* HTTP required definitions */
extern int	responseTypes[];
extern char	*full[];
extern char	*requestTypes[];

typedef struct {
    unsigned long	count;
    unsigned long	bytes;
    unsigned long	lastTime;
} WwwRequestIn;

typedef struct {
    unsigned long       count;
    unsigned long       bytes; 
    unsigned long       lastTime;
} WwwRequestOut;

typedef struct {
    unsigned long       count;
    unsigned long       bytes; 
    unsigned long       lastTime;
} WwwResponseIn;

typedef struct {
    unsigned long       count;
    unsigned long       bytes; 
    unsigned long       lastTime;
} WwwResponseOut;

#define MAX_DOCNAME     256
#define MAX_STATMSG     16

#ifndef MAX_LASTNSIZE
#define MAX_LASTNSIZE		25
#endif
#define DEFAULT_LASTNSIZE	25

#ifndef MAX_BUCKETS
#define MAX_BUCKETS		5
#endif
#define DEFAULT_BUCKETS		2

#ifndef	MAX_TOPNSIZE
#define	MAX_TOPNSIZE		25
#endif
#define DEFAULT_TOPNSIZE	25

typedef struct {
    unsigned char	docName[ MAX_DOCNAME ];
    time_t		requestTime;
    int			requestType;
    int			responseType;
#ifdef WWW_DOCUMENTS_GROUP
    unsigned char	statusMsg[ MAX_STATMSG ];
    unsigned long	docBytes;
#endif /* WWW_DOCUMENTS_GROUP */
} WwwDocLastN;

typedef struct {
    unsigned char	name[ MAX_DOCNAME ];
    unsigned long	accesses;
    unsigned long	bytes;
    int			lastResponseType;
    time_t		lastAccess; /* This one is only internal used. */
} WwwDocTopN;

typedef struct {
    time_t		bucketCreateTime;
    unsigned long	accesses;
    unsigned long	documents;
    unsigned long	bytes;
    WwwDocTopN		accessTopNTable[ MAX_TOPNSIZE ];
    WwwDocTopN		bytesTopNTable[ MAX_TOPNSIZE ];
} WwwDocBucket;

/* Some database defintions that are required for the buckets */
#ifdef USE_DB
#include <db.h>
#define BUCKET_DB	DB*
#define RECORD_INSERT	0
#define RECORD_REPLACE	0
#define FIRST_RECORD	R_FIRST
#define NEXT_RECORD	R_NEXT
#elif USE_DB2
#include <db.h>
#define BUCKET_DB	DB*
#define RECORD_INSERT	0
#define RECORD_REPLACE	0
#define FIRST_RECORD	R_FIRST
#define NEXT_RECORD	R_NEXT
#elif USE_DBM
#include <dbm.h>
#elif USE_NDBM
#include <ndbm.h>
#endif

typedef struct {
    /* www protocol summary statistics */
    /* wwwSummaryTable */
    unsigned long	summaryInRequests;
    unsigned long	summaryOutRequests;
    unsigned long	summaryInResponses;
    unsigned long	summaryOutResponses;
    /*    unsigned long	summaryInBytes; */
    unsigned long	summaryInLowBytes;
    /*    unsigned long	summaryOutBytes; */
    unsigned long	summaryOutLowBytes;
#ifdef WWW_REQUEST_IN_GROUP
    WwwRequestIn	requestInEntries[ METHODS - 1 ];
#endif
#ifdef WWW_REQUEST_OUT_GROUP
    WwwRequestOut	requestOutEntries[ METHODS ];
#endif
#ifdef WWW_RESPONSE_IN_GROUP
    WwwResponseIn	responseInEntries[ RESPONSE_CODES ];
#endif
#ifdef WWW_RESPONSE_OUT_GROUP
    WwwResponseOut	responseOutEntries[ RESPONSE_CODES ];
#endif
#ifdef WWW_DOCUMENTS_GROUP
    /* wwwDocCtrlTables */
    unsigned long      docCtrlLastNSize;
    unsigned long      snmpset_temp_docCtrlLastNSize;
    unsigned long      docCtrlLastNLock;
    unsigned long      snmpset_temp_docCtrlLastNLock;
    unsigned long      docCtrlBuckets;
    unsigned long      snmpset_temp_docCtrlBuckets;
    unsigned long      docCtrlBucketTimeInterval;
    unsigned long      snmpset_temp_docCtrlBucketTimeInterval;
    unsigned long      docCtrlTopNSize;
    unsigned long      snmpset_temp_docCtrlTopNSize;
    /* wwwDocLastNtable */
    WwwDocLastN docLastNTable[ MAX_LASTNSIZE ];
    unsigned long      docLastNIndex;
    /* wwwDocBucketTables */
    WwwDocBucket	docBucketTable[ MAX_BUCKETS ];
    unsigned long	docBucketIndex;
    /* just internal required */
    BUCKET_DB		bucket;
    char		*bucketName;
#endif
} WwwStats;

/* Definitions for the HTTP-SNMP API */
#define HTTP_2_SNMP_SOCKETNAME	"logs/http2snmp_socket"

#define SNMP_AGT_BUCKET_DEFAULT_DIR "logs/"

typedef struct {
    int 		serviceIndex;
    time_t		requestTime;
    unsigned long	requestInType;
    unsigned long	responseOutType;
    unsigned long	bytesIn;
    unsigned long	bytesOut;
    unsigned char	docName[ MAX_DOCNAME ];
    unsigned char	statusMsg[ MAX_STATMSG ];
} ApiMsg;

const char *init_sysDescr(cmd_parms *cmd, void *dummy, char *arg);
const char *init_sysContact(cmd_parms *cmd, void *dummy, char *arg);
const char *init_sysLocation(cmd_parms *cmd, void *dummy, char *arg);

extern	command_rec config_cmds_snmp_module[];
int	log_snmp_module(request_rec *r);
/*int	http_log_lastDocument(request_rec *r);
int	snmp_log_lastDocument(int socket);*/
void	init_snmp_module(server_rec *s, pool *p);
void	cleanup_snmp_module();
void	snmp_agt_main(server_rec *s, pool *p, pool *ptemp);


/* generic api for bucket handling. Then only buckets.c and mod_snmp.h
 * requires things for system DB's such as DB or DBM.
 */
BUCKET_DB	ap_bucket_open(char *name);
void		ap_bucket_close(BUCKET_DB bucket);
WwwDocTopN	*ap_bucket_fetch(BUCKET_DB bucket, char *keystr);
WwwDocTopN	*ap_bucket_seqfetch(BUCKET_DB bucket, int action);
int		ap_bucket_store(BUCKET_DB bucket, char *keystr,
			WwwDocTopN *record, int action);
const char	*ap_bucket_strerror();

#endif	/* _MOD_SNMP_H_ */
