/* ====================================================================
 * Copyright (c) 1997-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@mod-snmp.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 */

 
#include <httpd.h>
#include "http_config.h"
#include <http_conf_globals.h>
#include <scoreboard.h>

/* SNMP includes */
#include "asn1.h"
#include "snmp.h"
#include "agt_mib.h"
#include "agt_engine.h"
#include "scoreboard-mib.h"
#include "snmpv2-mib.h"

#include "mod_snmp.h"


/* APACHE_SCOREBOARD_MIB initialisation (must also register the MIB module tree */
void init_APACHE_SCOREBOARD_MIB()
{

    register_subtrees_of_APACHE_SCOREBOARD_MIB();
    /* insert the Object Resource in sysORTable */
    { static struct sysOREntry_struct value = { NULL, 1, {8, {O_scoreboardMIB}}, "The Scoreboard MIB module", 0};
      insert_sysOREntry(&value);
    }

}

int
create_scoreBoard_Index(int searchType, 
	Oid *req_oid, Oid *var_oid)
{
int     var_oidlen = var_oid->namelen++;
int	i;

    for ( i=0 ; i < HARD_SERVER_LIMIT; ++i) {
	if (ap_scoreboard_image->parent[ i ].pid) {
	    var_oid->name[ var_oidlen ] = (i +1);
	    if (searchType == NEXT) {
		if ( 0 > compare(req_oid, var_oid)) {
		    return(i);
		}
	    } else {
		if ( 0 == compare(req_oid, var_oid)) {
		    return(i);
		}
	    }
	}
    }
    return(-1);
}	

unsigned char *
var_scoreBoardEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)())
{
/* Last subOID of COLUMNAR OID is column */
int		column = newoid->name[(newoid->namelen - 1)];
int		score_index;
server_rec	*vh;

    ap_sync_scoreboard_image();
    score_index = create_scoreBoard_Index(searchType, reqoid, newoid);
    if (score_index < 0) {
	return(NULL);
    }
    switch (column) {
	case I_scoreBoardIndex:
	    return (unsigned char *) NULL;
	case I_scoreBoardProcessId:
	    *var_len = sizeof(pid_t);
	    return (unsigned char *) &(ap_scoreboard_image->parent[ score_index ].pid);
	case I_scoreBoardStatus:
	    *var_len = sizeof(long_return);
	    long_return = ap_scoreboard_image->servers[ score_index ].status;
	    return (unsigned char *) &(long_return);
	case I_scoreBoardStartTime:
	    *var_len = sizeof(long_return);
            long_return = ap_scoreboard_image->servers[ score_index ].status;
            return (unsigned char *) &(long_return);
	case I_scoreBoardAccessCount:
	    *var_len = sizeof(long_return);
            long_return = ap_scoreboard_image->servers[ score_index ].access_count;
            return (unsigned char *) &(long_return);
	case I_scoreBoardAccessBytes:
	    *var_len = sizeof(long_return);
            long_return = ap_scoreboard_image->servers[ score_index ].bytes_served;
            return (unsigned char *) &(long_return);
	case I_scoreBoardClient:
	    *var_len = strlen(ap_scoreboard_image->servers[ score_index ].client);
	    return (unsigned char *) ap_scoreboard_image->servers[ score_index ].client;
	case I_scoreBoardRequest:
	    *var_len = strlen(ap_scoreboard_image->servers[ score_index ].request);
	    return (unsigned char *) ap_scoreboard_image->servers[ score_index ].request;
	case I_scoreBoardVirtualHost:
	    vh = ap_scoreboard_image->servers[ score_index ].vhostrec;
	    if (vh) {
		*var_len = sizeof(vh->vhost_index);
		return (unsigned char *) vh->vhost_index;
	    } else {
		*var_len = sizeof(long_return);
		long_return = 0;
		return (unsigned char *) &long_return;
	    }
        default:
            return NULL;
    }
}


static oid scoreBoardEntry_oid[] = { O_scoreBoardEntry };
static Object scoreBoardEntry_variables[] = {
    { SNMP_UINTEGER, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardProcessId }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardStatus }}},
    { SNMP_TIMETICKS, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardStartTime }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardAccessCount }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardAccessBytes }}},
    { SNMP_STRING, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardClient }}},
    { SNMP_STRING, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardRequest }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_scoreBoardEntry,
                {1, { I_scoreBoardVirtualHost }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree scoreBoardEntry_tree =  { NULL, scoreBoardEntry_variables,
	        (sizeof(scoreBoardEntry_oid)/sizeof(oid)), scoreBoardEntry_oid};

/* This is the MIB registration function. This should be called */
/* within the init_APACHE_SCOREBOARD_MIB-function */
void register_subtrees_of_APACHE_SCOREBOARD_MIB()
{
    insert_group_in_mib(&scoreBoardEntry_tree);
}
