/* ====================================================================
 * Copyright (c) 1997-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@mod-snmp.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 *
 */


/* Apache includes */
#include "httpd.h"
#include "http_config.h"

/* mod_snmp includes */
#include "mod_snmp.h"

/* SNMP includes */
#include "asn1.h"
#include "snmp.h"
#include "agt_mib.h"
#include "agt_engine.h"
#include "snmpv2-mib.h"

struct timeval snmp_boottime;
char *sysDescr_value = SERVER_VERSION " - " SERVER_PROTOCOL " - " SNMP_AGT_VERSION;
char *sysLocation_value = "[no location given]";
char *sysContact_value = "[no address given]";

/* SNMPv2_MIB initialisation (must also register the MIB module tree */
void init_SNMPv2_MIB()
{

    gettimeofday(&snmp_boottime, (struct timezone *)0);
    register_subtrees_of_SNMPv2_MIB();
}

const char*
init_sysDescr(cmd_parms *cmd, void *dummy, char *arg)
{
    pool *p = cmd->pool;
    int i = strlen(arg);

    if (i > MAX_OCTSTR_LEN) {
	i = MAX_OCTSTR_LEN;
    }
    sysDescr_value = (char *)ap_pcalloc (p, i+1);
    if (sysDescr_value) {
	strncpy(sysDescr_value, arg, i);
    }
    return NULL;
}

unsigned char *
var_sysDescr(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = strlen(sysDescr_value);
    /* return the value */
    return (unsigned char *) sysDescr_value;
}

unsigned char *
var_sysObjectID(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
/* OID enterprises.universityOfTwente.4 */
static int version_oid[] = {O_enterprises, 785, 4};

    *write_method = 0;
    *var_len = sizeof(version_oid);
    /* return the value */
    return (unsigned char *) version_oid;
}

unsigned long	time2sysUpTime(time_t theTime)
{
   return((theTime - snmp_boottime.tv_sec) * 100
		+ snmp_boottime.tv_usec / 10000);
}

unsigned long    current_sysUpTime()
{
struct timeval  now;

    gettimeofday(&now, (struct timezone *)0);
    return ((now.tv_sec - snmp_boottime.tv_sec) * 100
	 	+ (now.tv_usec - snmp_boottime.tv_usec) / 10000);
}




unsigned char *
var_sysUpTime(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = sizeof(long);
    /* return the value */
    long_return = current_sysUpTime();
    return (unsigned char *) &long_return;
}

const char*
init_sysContact(cmd_parms *cmd, void *dummy, char *arg)
{
    pool *p = cmd->pool;
    int i = strlen(arg);

    if (i > MAX_OCTSTR_LEN) {
	i = MAX_OCTSTR_LEN;
    }
    sysContact_value = (char *)ap_pcalloc (p, i+1);
    if (sysContact_value) {
	strncpy(sysContact_value, arg, i);
    }
    return NULL;
}

/* NOT implemented
int	write_sysContact(int action,
	unsigned char *var_val, unsigned char varval_type, int var_val_len
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case RESERVE1:
    case RESERVE2:
    case COMMIT:
    case FREE:
    }
}
*/

unsigned char *
var_sysContact(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = strlen(sysContact_value);
    /* return the value */
    return (unsigned char *) sysContact_value;
}

/* NOT implemented
int	write_sysName(int action,
	unsigned char *var_val, unsigned char varval_type, int var_val_len
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case RESERVE1:
    case RESERVE2:
    case COMMIT:
    case FREE:
    }
}
*/

unsigned char *
var_sysName(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = sizeof(long);
    if (0 == gethostname(return_buf, 50)) {
	*var_len = strlen(return_buf);
	return (unsigned char *) return_buf;
	}
    /* Should be GENERR */
    *var_len = sizeof(long);
    long_return = 0;
    return (unsigned char *) &long_return;
}

const char*
init_sysLocation(cmd_parms *cmd, void *dummy, char *arg)
{
    pool *p = cmd->pool;
    int i = strlen(arg);

    if (i > MAX_OCTSTR_LEN) {
	i = MAX_OCTSTR_LEN;
    }
    sysLocation_value = (char *)ap_pcalloc (p, i+1);
    if (sysLocation_value) {
	strncpy(sysLocation_value, arg, i);
    }
    return NULL;
}

/* NOT implemented
int	write_sysLocation(int action,
	unsigned char *var_val, unsigned char varval_type, int var_val_len
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case RESERVE1:
    case RESERVE2:
    case COMMIT:
    case FREE:
    }
}
*/

unsigned char *
var_sysLocation(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = strlen(sysLocation_value);
    return (unsigned char *) sysLocation_value;
}

/* loosely defined OSI layers :-) of the sysService
 * field in systemgroup in SNMPv2
 */
#define SS_PHYS         1
#define SS_DATALINK     2
#define SS_INET         4
#define SS_END2END      8
#define SS_SMTP         64

unsigned char *
var_sysServices(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = sizeof(long);
    long_return = (long) SS_SMTP | SS_END2END | SS_INET ;
    return (unsigned char *) &long_return;
}

unsigned long sysORLastChange_value = 0;

unsigned char *
var_sysORLastChange(int *var_len,
        snmp_info_t *mesg, int (**write_method)() )
{
    *write_method = 0;
    *var_len = sizeof(sysORLastChange_value);
    return (unsigned char *) &sysORLastChange_value;
}

struct sysOREntry_struct sysOREntry_snmpV2_value = { NULL, 1, {7, {O_snmpMIB}}, "The MIB module for SNMPv2 entities", 0};
struct sysOREntry_struct *sysOREntry_root = &sysOREntry_snmpV2_value;

int insert_sysOREntry(struct sysOREntry_struct *value)  
{
struct sysOREntry_struct *current = sysOREntry_root;

    while (current->next) {
            current = current->next;
    }
    value->index = current->index + 1;
    current->next = value;
    sysORLastChange_value = current_sysUpTime();
    current->lastChange = sysORLastChange_value;
    return(0); 
}   

unsigned char *
var_sysOREntry( int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)() )
{
/* Last subOID of COLUMNAR OID is column */
int     column = newoid->name[(newoid->namelen - 1)];
int     sysORIndex = newoid->namelen++;
/* Variables defined */
int     result;
struct sysOREntry_struct *current = sysOREntry_root;

    while (current) { 
	newoid->name[ sysORIndex ] = current->index;
	result = compare(reqoid, newoid);
	if (((searchType == EXACT) && (result == 0)) ||
		((searchType == NEXT) && (result < 0))) {
	   break;
        }
	current = current->next;
    }
    if (current == NULL) return(NULL);

    *write_method = 0;

    switch (column) {
	case I_sysORIndex:
	    return (unsigned char *) NULL;
	case I_sysORID:
	    *var_len = current->oid_value.namelen * sizeof(oid);
	    return (unsigned char *) &(current->oid_value.name);
	case I_sysORDescr:
	    *var_len = strlen(current->descr);
	    return (unsigned char *) current->descr;
	case I_sysORUpTime:
	    *var_len = sizeof(unsigned long);
            return (unsigned char *) &(current->lastChange);
	default:
	    return NULL;
    }
}

unsigned char *
var_snmpInPkts(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpInPkts_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpInPkts_instance;
}

unsigned char *
var_snmpInBadVersions(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpInBadVersions_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpInBadVersions_instance;
}


unsigned char *
var_snmpInBadCommunityNames(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpInBadCommunityNames_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpInBadCommunityNames_instance;
}


unsigned char *
var_snmpInBadCommunityUses(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpInBadCommunityUses_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpInBadCommunityUses_instance;
}


unsigned char *
var_snmpInASNParseErrs(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpInASNParseErrs_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpInASNParseErrs_instance;
}

/*
int	write_snmpEnableAuthenTraps(int action,
	unsigned char *var_val, unsigned char varval_type, int var_val_len
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case RESERVE1:
    case RESERVE2:
    case COMMIT:
    case FREE:
    }
}
*/

unsigned char *
var_snmpEnableAuthenTraps(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpEnableAuthenTraps_instance;

/* Set now only to disabled TBD */
    snmpEnableAuthenTraps_instance = 2;
    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpEnableAuthenTraps_instance;
}

unsigned char *
var_snmpSilentDrops(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
 extern long	snmpSilentDrops_instance;
 
    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpSilentDrops_instance;
}

unsigned char *
var_snmpProxyDrops(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
extern long	snmpProxyDrops_instance;

    *write_method = 0;
    *var_len = sizeof(long);
    return (unsigned char *) &snmpProxyDrops_instance;
}

unsigned char *
var_snmpTrapOID(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpTrapEnterprise(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}
/*
int	write_snmpSetSerialNo(int action,
	unsigned char *var_val, unsigned char varval_type, int var_val_len
	unsigned char *statP, oid *name, int name_len)
{
    switch (action) {
    case RESERVE1:
    case RESERVE2:
    case COMMIT:
    case FREE:
    }
}
*/

unsigned char *
var_snmpSetSerialNo(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutPkts(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInTooBigs(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInNoSuchNames(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInBadValues(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInReadOnlys(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInGenErrs(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInTotalReqVars(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInTotalSetVars(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInGetRequests(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInGetNexts(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInSetRequests(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInGetResponses(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpInTraps(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutTooBigs(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutNoSuchNames(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutBadValues(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutGenErrs(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutGetRequests(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutGetNexts(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutSetRequests(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutGetResponses(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}

unsigned char *
var_snmpOutTraps(int *var_len,
	snmp_info_t *mesg, int (**write_method)()	)
{
    /* Determine additional access-rights */
    /* Add additional value computations */

    /* Set write-function */
    *write_method = 0;
    /* Set size of the variable (in bytes) */
    *var_len = sizeof(long);
    /* Return the value (address pointer)*/
    return (unsigned char *) NULL;
}



static oid system_oid[] = { O_system };
static Object system_variables[] = {
    { SNMP_STRING, (RONLY| SCALAR), var_sysDescr,
                 {2, { I_sysDescr, 0 }}},
    { SNMP_OBJID, (RONLY| SCALAR), var_sysObjectID,
                 {2, { I_sysObjectID, 0 }}},
    { SNMP_TIMETICKS, (RONLY| SCALAR), var_sysUpTime,
                 {2, { I_sysUpTime, 0 }}},
    { SNMP_STRING, (RWRITE| SCALAR), var_sysContact,
                 {2, { I_sysContact, 0 }}},
    { SNMP_STRING, (RWRITE| SCALAR), var_sysName,
                 {2, { I_sysName, 0 }}},
    { SNMP_STRING, (RWRITE| SCALAR), var_sysLocation,
                 {2, { I_sysLocation, 0 }}},
    { SNMP_INTEGER, (RONLY| SCALAR), var_sysServices,
                 {2, { I_sysServices, 0 }}},
    { SNMP_TIMETICKS, (RONLY| SCALAR), var_sysORLastChange,
                 {2, { I_sysORLastChange, 0 }}},
    { SNMP_OBJID, (RONLY| COLUMN), var_sysOREntry,
                {3, { I_sysORTable, I_sysOREntry, I_sysORID }}},
    { SNMP_STRING, (RONLY| COLUMN), var_sysOREntry,
                {3, { I_sysORTable, I_sysOREntry, I_sysORDescr }}},
    { SNMP_TIMETICKS, (RONLY| COLUMN), var_sysOREntry,
                {3, { I_sysORTable, I_sysOREntry, I_sysORUpTime }}},
    { 0, 0, NULL, {0, {0}} }
    };
static SubTree system_tree =  { NULL, system_variables,
	        (sizeof(system_oid)/sizeof(oid)), system_oid};

static oid snmp_oid[] = { O_snmp };
static Object snmp_variables[] = {
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpInPkts,
                 {2, { I_snmpInPkts, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpInBadVersions,
                 {2, { I_snmpInBadVersions, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpInBadCommunityNames,
                 {2, { I_snmpInBadCommunityNames, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpInBadCommunityUses,
                 {2, { I_snmpInBadCommunityUses, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpInASNParseErrs,
                 {2, { I_snmpInASNParseErrs, 0 }}},
    { SNMP_INTEGER, (RWRITE| SCALAR), var_snmpEnableAuthenTraps,
                 {2, { I_snmpEnableAuthenTraps, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpSilentDrops,
                 {2, { I_snmpSilentDrops, 0 }}},
    { SNMP_COUNTER, (RONLY| SCALAR), var_snmpProxyDrops,
                 {2, { I_snmpProxyDrops, 0 }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree snmp_tree =  { NULL, snmp_variables,
	        (sizeof(snmp_oid)/sizeof(oid)), snmp_oid};
/*
 * static oid snmpSet_oid[] = { O_snmpSet };
 * static Object snmpSet_variables[] = {
 *     { SNMP_INTEGER, (RWRITE| SCALAR), var_snmpSetSerialNo,
 *                  {2, { I_snmpSetSerialNo, 0 }}},
 *     { NULL }
 *     };
 * static SubTree snmpSet_tree =  { NULL, snmpSet_variables,
 *                  (sizeof(snmpSet_oid)/sizeof(oid)), snmpSet_oid};
 */

/* This is the MIB registration function. This should be called */
/* within the init_SNMPv2_MIB-function */
void register_subtrees_of_SNMPv2_MIB()
{
    insert_group_in_mib(&system_tree);
    insert_group_in_mib(&snmp_tree);
/*  insert_group_in_mib(&snmpSet_tree); */
}
