/* ====================================================================
 * Copyright (c) 1997-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is harrie@mod-snmp.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 *
 */

/* Apache includes */
#include "httpd.h"
#include "scoreboard.h"
#include "http_config.h"

/* SNMP includes */
#include "asn1.h"
#include "snmp.h"
#include "agt_engine.h"
#include "agt_mib.h"
#include "www-mib.h"
#include "snmpv2-mib.h"

#include "mod_snmp.h"


#ifndef MIN
#define MIN(A,B)	A<B?A:B
#endif

extern server_rec       *www_services;
extern scoreboard	*ap_scoreboard_image;

/* WWW_MIB initialisation (must also register the MIB module tree */
void init_WWW_MIB()
{

    register_subtrees_of_WWW_MIB();
    /* insert the Object Resource in sysORTable */
    { static struct sysOREntry_struct value = { NULL, 1, {7, {O_wwwMIB}}, "The WWW service MIB module", 0};
      insert_sysOREntry(&value);
    }

}



void
init_wwwServiceOperStatus()
{
int i;

    if (ap_scoreboard_image) {
	for (i=0; i < HARD_VIRTUAL_HOST_MAX ; i++) {
	    ap_scoreboard_image->global.operStatus[i] = VHOST_RUNNING;
	}
    }
}

int
vHostOperational(int hostNr)
{
    if (ap_scoreboard_image->global.operStatus[ hostNr ] == VHOST_RUNNING)
	return(0);
    return(1);
}


int
getOperStatusOf(int hostNr)
{
    return(ap_scoreboard_image->global.operStatus[hostNr]);
}

int
getLastChangeOf(int hostNr)
{
    return(ap_scoreboard_image->global.lastChange[hostNr]);
}


server_rec *
serviceIndexCreation(int searchType, server_rec *server,
	Oid *req_oid, Oid *var_oid)
{
int	var_oidlen = var_oid->namelen++;

    while (server) {
        var_oid->name[ var_oidlen ] = (server->vhost_index) + 1;
        switch (searchType) {
            case NEXT:
                if ( 0 > compare(req_oid, var_oid)) {
                    return(server);
                }
                break;
            case EXACT:
                if ( 0 == compare(req_oid, var_oid)) {
                    return(server);
                }
                break;
            case INDEX:
                if ( 0 >= compare_tree(req_oid, var_oid)) {
                    return(server);
                }
                break;
        }
        server = server->next;
    }
    return(NULL);
}

unsigned char *
var_wwwServiceEntry( int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
static oid	protocol_oid[] = { O_mib_2, 6, 80 };
int		column = newoid->name[11];
server_rec	*service;

    service = serviceIndexCreation(searchType, www_services, reqoid, newoid);
    if (!service) {
	return NULL; 
    }

    *write_method = 0;
    *var_len = sizeof(long);
    switch (column) {
/*	case I_wwwServiceIndex:
	    return (unsigned char *) NULL; not-accesible */
	case I_wwwServiceDescription:
	    strcpy(return_buf, SERVER_VERSION " - " SERVER_PROTOCOL " - " SNMP_AGT_VERSION); 
	    *var_len = strlen(return_buf);
	    return (unsigned char *) return_buf;
	case I_wwwServiceContact:
	    *var_len = strlen(service->server_admin);
	    return (unsigned char *) service->server_admin;
	case I_wwwServiceProtocol:
	    *var_len = sizeof(protocol_oid);
	    return (unsigned char *) protocol_oid;
	case I_wwwServiceName:
	    *var_len = strlen(service->server_hostname);
	    return (unsigned char *) service->server_hostname;
	case I_wwwServiceType:
	    long_return = 2; /* server only */
	    return (unsigned char *) &long_return;
	case I_wwwServiceStartTime:
	    *var_len = snmp_time2DateAndTime(ap_restart_time, return_buf);
	    return (unsigned char *) return_buf;
	case I_wwwServiceOperStatus:
	    long_return = getOperStatusOf(service->vhost_index);
	    return (unsigned char *) &long_return;
	case I_wwwServiceLastChange:
	    *var_len = snmp_time2DateAndTime(ap_restart_time, return_buf);
	    return (unsigned char *) return_buf;
        default:
            return NULL;
    }
}

unsigned char *
var_wwwSummaryEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
WwwStats	*wwwStats;
server_rec	*service;

    service = serviceIndexCreation(searchType, www_services, reqoid, newoid);
    if (!service) {
	return NULL;
    }
    wwwStats = service->snmp_www_stats;
    *var_len = sizeof(long);

    switch (column) {
	case I_wwwSummaryInRequests:
	    return (unsigned char *) &(wwwStats->summaryInRequests);
	case I_wwwSummaryOutRequests:
	    return (unsigned char *) NULL;
	case I_wwwSummaryInResponses:
	    return (unsigned char *) NULL;
	case I_wwwSummaryOutResponses:
	    return (unsigned char *) &(wwwStats->summaryOutResponses);
	case I_wwwSummaryInBytes:
	    return (unsigned char *) NULL;
	case I_wwwSummaryInLowBytes:
	    return (unsigned char *) &(wwwStats->summaryInLowBytes);
	case I_wwwSummaryOutBytes:
	    return (unsigned char *) NULL;
	case I_wwwSummaryOutLowBytes:
	    return (unsigned char *) &(wwwStats->summaryOutLowBytes);
        default:
            return NULL;
    }
}


int
methodIndexCreation( int searchType, Oid *req_oid, Oid *var_oid)
{
int     methodArrayIndex;
int     i, result;
int	var_oidlen = var_oid->namelen + 1;

    /* NOTE: "METHODS-1", since INVALID is also included in METHODS */
    for(methodArrayIndex=0; methodArrayIndex < METHODS -1; methodArrayIndex++) {

        var_oid->name[ var_oidlen - 1 ] = strlen(requestTypes[methodArrayIndex]);

        /* build the OID string from the chars as in the status_codes.h
         * file; which is automatically made from httpd.h; NOTE that things
         * barf horribly if the httpd.h file and this status_codes.h file
         * are out of sync! Also note that the sort order is of importance.
         */
        for(i=0;i<strlen(requestTypes[methodArrayIndex]);i++)
                var_oid->name[ var_oidlen + i ] = requestTypes[methodArrayIndex][i];
	var_oid->namelen =  var_oidlen + i;
        result = compare(req_oid, var_oid);
        /* return, depending of the type of search we are doing
	 * if (searchType == EXACT and result == 0) OR
	 *    (searchType == NEXT  and result <  0)
	 */
        if (((searchType == EXACT) && (result == 0)) ||
			((searchType == NEXT) && (result < 0))) {
            return(methodArrayIndex);
        } /* if */

     } /* for loop */
return(-1);
}

#ifdef WWW_REQUEST_IN_GROUP
unsigned char *
var_wwwRequestInEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
WwwStats	*wwwStats;
server_rec	*service = www_services;
int		methodIndex;

    do {
        service = serviceIndexCreation(INDEX, service, reqoid, newoid);
        if (!service) return(NULL);
	wwwStats = service->snmp_www_stats;
	if (wwwStats) {
            methodIndex = methodIndexCreation(searchType, reqoid, newoid) ;
            if ( methodIndex < 0 ) {
		service = service->next;
		newoid->namelen = 12;
	    }
	} else {
	    methodIndex = -1;
	}
    } while ( methodIndex < 0 );

    *var_len = sizeof(long);    /* default length */
    switch (column) {
/*	case I_wwwRequestInIndex:
	    return (unsigned char *) NULL; not-accessable */
	case I_wwwRequestInRequests:
	    return (unsigned char *) &(wwwStats->requestInEntries[methodIndex].count);
	case I_wwwRequestInBytes:
	    return (unsigned char *) &(wwwStats->requestInEntries[methodIndex].bytes);
	case I_wwwRequestInLastTime:
	    *var_len = snmp_time2DateAndTime(wwwStats->requestInEntries[methodIndex].lastTime, return_buf);
	    return (unsigned char *) return_buf;
        default:
            return NULL;
    }
}
#endif

#ifdef WWW_REQUEST_OUT_GROUP
unsigned char *
var_wwwRequestOutEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int     column = newoid->name[11];
/* Variables defined */
int	result;

/* Check OID */
    result = compare(reqoid, newoid);
    if (((searchType == EXACT) && (result != 0)) ||
        ((searchType == NEXT) && (result >= 0)))
        return NULL;

    *write_method = 0;
    *var_len = sizeof(long);    /* default length */

    switch (column) {
	case I_wwwRequestOutIndex:
	    return (unsigned char *) NULL;
	case I_wwwRequestOutRequests:
	    return (unsigned char *) NULL;
	case I_wwwRequestOutBytes:
	    return (unsigned char *) NULL;
	case I_wwwRequestOutLastTime:
	    return (unsigned char *) NULL;
        default:
            return NULL;
    }
}
#endif /* WWW_REQUEST_OUT_GROUP */

#ifdef WWW_RESPONSE_OUT_GROUP
int
responseCodeIndexCreation(int searchType, Oid *req_oid, Oid *var_oid  )
{
int	responseArrayIndex;
int	result;
int	var_oidLen = var_oid->namelen++;

    responseArrayIndex = 0;
    while (responseTypes[ responseArrayIndex ] > 0) {
	var_oid->name[ var_oidLen ] = responseTypes[responseArrayIndex];
	result = compare(req_oid, var_oid);
	if (((searchType == EXACT) && (result == 0)) || ((searchType == NEXT) && (0 > result))) {
	    return(responseArrayIndex);
	} /* if */
	responseArrayIndex++;
    } /* for */
return(-1);
}
#endif

#ifdef WWW_RESPONSE_IN_GROUP
unsigned char *
var_wwwResponseInEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int     column = newoid->name[(newoid->namelen - 1)];
int	result;

    /* Check OID */
    result = compare(reqoid, newoid);
    if (((searchType == EXACT) && (result != 0)) ||
        ((searchType == NEXT) && (result >= 0)))
        return NULL;

    *write_method = 0;
    *var_len = sizeof(long);    /* default length */

    switch (column) {
	case I_wwwResponseInIndex:
	    return (unsigned char *) NULL;
	case I_wwwResponseInResponses:
	    return (unsigned char *) NULL;
	case I_wwwResponseInBytes:
	    return (unsigned char *) NULL;
	case I_wwwResponseInLastTime:
	    return (unsigned char *) NULL;
        default:
            return NULL;
    }
}
#endif /* WWW_RESPONSE_IN_GROUP */

#ifdef WWW_RESPONSE_OUT_GROUP
unsigned char *
var_wwwResponseOutEntry( int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
WwwStats	*wwwStats;
server_rec	*service = www_services;
int		responseIndex;

    do {
	service = serviceIndexCreation(INDEX, service, reqoid, newoid);
	if (!service) {
	    return(NULL);
	}
	wwwStats = service->snmp_www_stats;
	if (wwwStats) {
	    responseIndex = responseCodeIndexCreation(searchType, reqoid, newoid);
            if ( responseIndex < 0 ) {
		service =  service->next;
		newoid->namelen = 12;
	    }
        } else {
	    responseIndex = -1;
	}
    } while ( responseIndex < 0 );

    *var_len = sizeof(long);    /* default length */
    switch (column) {
/*	case I_wwwResponseOutIndex:
	    return (unsigned char *) NULL; */
	case I_wwwResponseOutResponses:
	    return (unsigned char *) &(wwwStats->responseOutEntries[responseIndex].count);
	case I_wwwResponseOutBytes:
	    return (unsigned char *) &(wwwStats->responseOutEntries[responseIndex].bytes);
	case I_wwwResponseOutLastTime:
	    *var_len = snmp_time2DateAndTime(wwwStats->responseOutEntries[responseIndex].lastTime, return_buf);
	    return (unsigned char *) return_buf;
        default:
            return NULL;
    }
}
#endif /* WWW_RESPONSE_OUT_GROUP */
#ifdef WWW_DOCUMENTS_GROUP
server_rec *get_wwwService_with_index(int index)
{
server_rec *service = www_services;

    index--;
    while (service) {
	if (service->vhost_index == index) {
	    return(service);
	}
	service = service->next;
    }
    return(NULL);
}

/* An entry used to configure the wwwDocLastNTable,
 * the wwwDocBucketTable, the wwwDocAccessTopNTable,
 * and the wwwDocBytesTopNTable.
 */
int
write_wwwDocCtrlLastNSize(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, Oid *setoid)
{
int size = 4;
int wwwServiceIndex = setoid->name[ setoid->namelen - 1];
server_rec *wwwService = get_wwwService_with_index(wwwServiceIndex);
WwwStats *wwwServiceSnmpData;

    if (wwwService == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }
    wwwServiceSnmpData = wwwService->snmp_www_stats;
    if (wwwServiceSnmpData == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_UINTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
        if (NULL == asn_parse_int(var_val, &size, &var_val_type,
	        (long *)&(wwwServiceSnmpData->snmpset_temp_docCtrlLastNSize),
		sizeof (unsigned long))) {
	    return(PARSE_ERROR);
	}
	if ((wwwServiceSnmpData->snmpset_temp_docCtrlLastNSize < 0) || (wwwServiceSnmpData->snmpset_temp_docCtrlLastNSize > MAX_LASTNSIZE)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break; 
    case COMMIT:
	wwwServiceSnmpData->docCtrlLastNSize = wwwServiceSnmpData->snmpset_temp_docCtrlLastNSize;
	break;
    case FREE:
	break;
    }
    return SNMP_ERROR_NOERROR;
}

int
write_wwwDocCtrlBuckets(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, Oid *setoid)
{
int size = 4;
int wwwServiceIndex = setoid->name[ setoid->namelen - 1];
server_rec *wwwService = get_wwwService_with_index(wwwServiceIndex);
WwwStats *wwwServiceSnmpData;

    if (wwwService == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }
    wwwServiceSnmpData = wwwService->snmp_www_stats;
    if (wwwServiceSnmpData == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_UINTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
        if (NULL == asn_parse_int(var_val, &size, &var_val_type,
	        (long *)&(wwwServiceSnmpData->snmpset_temp_docCtrlBuckets),
		sizeof (unsigned long))) {
	    return(PARSE_ERROR);
	}
	if ((wwwServiceSnmpData->snmpset_temp_docCtrlBuckets < 0) || (wwwServiceSnmpData->snmpset_temp_docCtrlBuckets > MAX_BUCKETS)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break; 
    case COMMIT:
	wwwServiceSnmpData->docCtrlBuckets = wwwServiceSnmpData->snmpset_temp_docCtrlBuckets;
	break;
    case FREE:
	break;
    }
    return SNMP_ERROR_NOERROR;
}

int
write_wwwDocCtrlBucketTimeInterval(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, Oid *setoid)
{
int size = 4;
int wwwServiceIndex = setoid->name[ setoid->namelen - 1];
server_rec *wwwService = get_wwwService_with_index(wwwServiceIndex);
WwwStats *wwwServiceSnmpData;

    if (wwwService == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }
    wwwServiceSnmpData = wwwService->snmp_www_stats;
    if (wwwServiceSnmpData == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_UINTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
        if (NULL == asn_parse_int(var_val, &size, &var_val_type,
	        (long *)&(wwwServiceSnmpData->snmpset_temp_docCtrlBucketTimeInterval),
		sizeof (unsigned long))) {
	    return(PARSE_ERROR);
	}
	/* We check here if the time is really in seconds. Although,	 */
	/* it should milliseconds the "alarm()"-function knows only seconds */
	/* We even protect ourselfs agains creating buckets each second. */
	/* Only possible in multiples of 10 seconds. */
	if ((wwwServiceSnmpData->snmpset_temp_docCtrlBucketTimeInterval % 1000) != 0) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break; 
    case COMMIT:
	wwwServiceSnmpData->docCtrlBucketTimeInterval = wwwServiceSnmpData->snmpset_temp_docCtrlBucketTimeInterval;
	break;
    case FREE:
	break;
    }
    return SNMP_ERROR_NOERROR;
}

int
write_wwwDocCtrlTopNSize(int action,
	unsigned char *var_val, unsigned char var_val_type, int var_val_len,
	unsigned char *statP, Oid *setoid)
{
int size = 4;
int wwwServiceIndex = setoid->name[ setoid->namelen - 1];
server_rec *wwwService = get_wwwService_with_index(wwwServiceIndex);
WwwStats *wwwServiceSnmpData;

    if (wwwService == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }
    wwwServiceSnmpData = wwwService->snmp_www_stats;
    if (wwwServiceSnmpData == NULL) {
        return(SNMP_ERROR_NOTWRITABLE);
    }

    switch (action) {
    case CHECK:
	if (var_val_type != SNMP_UINTEGER) {
	    return SNMP_ERROR_WRONGTYPE;
	}
        if (NULL == asn_parse_int(var_val, &size, &var_val_type,
	        (long *)&(wwwServiceSnmpData->snmpset_temp_docCtrlTopNSize),
		sizeof (unsigned long))) {
	    return(PARSE_ERROR);
	}
	if ((wwwServiceSnmpData->snmpset_temp_docCtrlTopNSize < 0) || (wwwServiceSnmpData->snmpset_temp_docCtrlTopNSize > MAX_TOPNSIZE)) {
	    return SNMP_ERROR_WRONGVALUE;
	}
	break; 
    case COMMIT:
	wwwServiceSnmpData->docCtrlTopNSize = wwwServiceSnmpData->snmpset_temp_docCtrlTopNSize;
	break;
    case FREE:
	break;
    }
    return SNMP_ERROR_NOERROR;
}

unsigned char *
var_wwwDocCtrlEntry(int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg,
	int (**write_method)(int, unsigned char *, unsigned char, int, unsigned char *, Oid *))
{
int		column = newoid->name[(newoid->namelen - 1)];
server_rec	*service;
WwwStats	*wwwStats;

    service = serviceIndexCreation(searchType, www_services, reqoid, newoid);
    if (!service) return(NULL);
    wwwStats = service->snmp_www_stats;
    if (!service->snmp_www_stats) return(NULL);
    *var_len = sizeof(long);
    switch (column) {
	case I_wwwDocCtrlLastNSize:
	    *write_method = write_wwwDocCtrlLastNSize;
	    return (unsigned char *) &(wwwStats->docCtrlLastNSize);
	case I_wwwDocCtrlLastNLock:
	  /*	    *write_method = write_wwwDocCtrlLastNLock;*/
	    *write_method = 0;
	    return (unsigned char *) &(wwwStats->docCtrlLastNLock);
	case I_wwwDocCtrlBuckets:
	    *write_method = write_wwwDocCtrlBuckets;
	    return (unsigned char *) &(wwwStats->docCtrlBuckets);
	case I_wwwDocCtrlBucketTimeInterval:
	    *write_method = write_wwwDocCtrlBucketTimeInterval;
	    return (unsigned char *) &(wwwStats->docCtrlBucketTimeInterval);
	case I_wwwDocCtrlTopNSize:
	    *write_method = write_wwwDocCtrlTopNSize;
	    return (unsigned char *) &(wwwStats->docCtrlTopNSize);
        default:
            return NULL;
    }
}


WwwDocLastN *
wwwDocLastNIndexCreation(int searchType, WwwStats *wwwStats,
		Oid* req_oid, Oid *var_oid)
{
int	result;

    if (!wwwStats) return(NULL);
    if (!wwwStats->docLastNTable) return(NULL);
    var_oid->namelen = 14;
    if (0 < (int)(wwwStats->docLastNIndex - wwwStats->docCtrlLastNSize)) {
	var_oid->name[13] = (wwwStats->docLastNIndex - wwwStats->docCtrlLastNSize);
    } else {
	var_oid->name[13] = 0;
    }
    while (++var_oid->name[13] <= wwwStats->docLastNIndex) {
	result = compare(req_oid, var_oid);
	if (((searchType == EXACT) && (result == 0)) ||
		((searchType == NEXT) && (result < 0))) {
	    return(&(wwwStats->docLastNTable[ var_oid->name[13] % MAX_LASTNSIZE ]));
	}
    }
    return(NULL);
}


unsigned char *
var_wwwDocLastNEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int     	column = newoid->name[11];
server_rec	*service = www_services;
WwwDocLastN	*currentRow;

    do {
	/* select first index 'wwwServiceIndex' */
	service = serviceIndexCreation(INDEX, service, reqoid, newoid);
	if (!service) return(NULL);

	currentRow = wwwDocLastNIndexCreation(searchType,
				service->snmp_www_stats, reqoid, newoid);
	if (!currentRow) {
	    service = service->next;	/* Go to next service		*/
	    newoid->namelen = 12;	/* Reset length of variable oid */
	}
    } while (!currentRow);

    *write_method = 0;
    *var_len = sizeof(long);    /* default length */
    switch (column) {
    /*	case I_wwwDocLastNIndex: not-accessible
	    return (unsigned char *) NULL; */
	case I_wwwDocLastNName:
	    *var_len = strlen(currentRow->docName);
	    return (unsigned char *) currentRow->docName;
	case I_wwwDocLastNTimeStamp:
	    *var_len = snmp_time2DateAndTime(currentRow->requestTime,
								return_buf);
	    return (unsigned char *) return_buf;
	case I_wwwDocLastNRequestType:
	    if (currentRow->requestType == -1) {
		*var_len = 0;
		return (unsigned char *) return_buf;
	    }
	    *var_len = strlen(requestTypes[currentRow->requestType]);
	    return (unsigned char *) requestTypes[currentRow->requestType];
	case I_wwwDocLastNResponseType:
	    if (currentRow->responseType) {
		*var_len = sizeof(unsigned long);
		return (unsigned char *) &responseTypes[currentRow->responseType];
	    }
	    return(NULL);
	case I_wwwDocLastNStatusMsg:
	    return(NULL);
	    *var_len = strlen(currentRow->statusMsg);
	    return (unsigned char *) currentRow->statusMsg;
	case I_wwwDocLastNBytes:
	    *var_len = sizeof(currentRow->docBytes);
	    return (unsigned char *) &currentRow->docBytes;
        default:
            return NULL;
    }
}

WwwDocBucket *
wwwDocBucketIndexCreation(int searchType, WwwStats *wwwStats,
                Oid* req_oid, Oid *var_oid)
{
int	result;

    if (!wwwStats) return(NULL);
    var_oid->namelen = 14;
    if (0 < (int)(wwwStats->docBucketIndex - wwwStats->docCtrlBuckets)) {
	var_oid->name[13] = wwwStats->docBucketIndex - wwwStats->docCtrlBuckets;
    } else {
	var_oid->name[13] = 0;
    }
    while ((++var_oid->name[13]) <= wwwStats->docBucketIndex) {
	result = compare(req_oid, var_oid);
	if (((searchType == EXACT) && (result == 0)) ||
				((searchType == NEXT) && (0 > result))) {
	    return(&(wwwStats->docBucketTable[ (int)var_oid->name[13] % MAX_BUCKETS ]));
	}
    }
    var_oid->namelen = 12; /* Reset the var_oid length */
    return(NULL);
}


unsigned char *
var_wwwDocBucketEntry(	int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
server_rec	*service = www_services;
WwwStats	*wwwStats;
WwwDocBucket	*bucket;

    do {
	/* select first index 'wwwServiceIndex' */
	service = serviceIndexCreation(INDEX, service, reqoid, newoid);
	if (!service) return(NULL);
	wwwStats = service->snmp_www_stats;
	if (!wwwStats) return(NULL);
	bucket = wwwDocBucketIndexCreation(searchType, wwwStats, reqoid, newoid);
	if (!bucket) {
	    service = service->next;
	}
    } while (!bucket);

    *write_method = 0;
    *var_len = sizeof(unsigned long);    /* default length */
    switch (column) {
    /*	case I_wwwDocBucketIndex:
	    return (unsigned char *) NULL; */
	case I_wwwDocBucketTimeStamp:
	    *var_len = snmp_time2DateAndTime(bucket->bucketCreateTime,
								return_buf);
	    return (unsigned char *) return_buf;
	case I_wwwDocBucketAccesses:
	    return (unsigned char *) &(bucket->accesses);
	case I_wwwDocBucketDocuments:
	    return (unsigned char *) &(bucket->documents);
	case I_wwwDocBucketBytes:
	    return (unsigned char *) &(bucket->bytes);
        default:
            return NULL;
    }
}
WwwDocTopN *
wwwDocTopNIndexCreation(int searchType, WwwStats *wwwStats, int whichTopN,
	Oid *req_oid, Oid *var_oid)
{
int		result;
WwwDocBucket	*bucket;
int		topNSize;

    if (!wwwStats) return(NULL);
    if (0 < (int)(wwwStats->docBucketIndex - wwwStats->docCtrlBuckets)) {
	var_oid->name[13] = wwwStats->docBucketIndex - wwwStats->docCtrlBuckets;
    } else {
	var_oid->name[13] = 0;
    }
    var_oid->namelen = 15;
    while ((++var_oid->name[13]) <= wwwStats->docBucketIndex) {
	bucket = &(wwwStats->docBucketTable[ var_oid->name[13] % MAX_BUCKETS ]);
	topNSize = MIN(bucket->documents, MIN(wwwStats->docCtrlTopNSize, 25));
	var_oid->name[14] = 0;
	while ((++var_oid->name[14]) <= topNSize) {
	     result = compare(req_oid, var_oid);
	     if (((searchType == EXACT) && (result == 0)) ||
				((searchType == NEXT) && (result < 0))) {
		if (whichTopN == 0) {
		     return(&(bucket->accessTopNTable[(var_oid->name[14] - 1)]));
		} else {
		     return(&(bucket->bytesTopNTable[(var_oid->name[14] - 1)]));
		}
	     }
	}
    }
    var_oid->namelen = 12; /* Reset the var_oid length */
    return(NULL);
}

unsigned char *
var_wwwDocAccessTopNEntry( int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
server_rec      *service = www_services;
WwwStats	*wwwStats;
WwwDocTopN	*currentRow;

    do {
	/* select first index 'wwwServiceIndex' */
	service = serviceIndexCreation(INDEX, service, reqoid, newoid);
	if (!service) return(NULL);
	wwwStats = service->snmp_www_stats;
	currentRow = wwwDocTopNIndexCreation(searchType, wwwStats, 0, reqoid, newoid);
	if (!currentRow) {
	    service = service->next;
	}
    } while (!currentRow);

    switch (column) {
	case I_wwwDocAccessTopNIndex:
	    return (unsigned char *) NULL;
	case I_wwwDocAccessTopNName:
	    *var_len = strlen(currentRow->name);
	    return (unsigned char *) currentRow->name;
	case I_wwwDocAccessTopNAccesses:
	    *var_len = sizeof(currentRow->accesses);
	    return (unsigned char *) &(currentRow->accesses);
	case I_wwwDocAccessTopNBytes:
	    *var_len = sizeof(currentRow->bytes);
	    return (unsigned char *) &(currentRow->bytes);
	case I_wwwDocAccessTopNLastResponseType:
	    *var_len = sizeof(currentRow->lastResponseType);
	    return (unsigned char *) &responseTypes[currentRow->lastResponseType];
        default:
            return NULL;
    }
}

unsigned char *
var_wwwDocBytesTopNEntry( int *var_len,
	Oid *newoid, Oid *reqoid, int searchType,
	snmp_info_t *mesg, int (**write_method)()	)
{
int		column = newoid->name[11];
server_rec      *service = www_services;
WwwStats	*wwwStats;
WwwDocTopN	*currentRow;

    do {
	/* select first index 'wwwServiceIndex' */
	service = serviceIndexCreation(INDEX, service, reqoid, newoid);
	if (!service) return(NULL);
	wwwStats =  service->snmp_www_stats;
	currentRow = wwwDocTopNIndexCreation(searchType, wwwStats, 1, reqoid, newoid);
	if (!currentRow) {
	    service = service->next; 
	}
    } while (!currentRow);

    *var_len = sizeof(long);    /* default length */
    switch (column) {
	case I_wwwDocBytesTopNIndex:
	    return (unsigned char *) NULL;
	case I_wwwDocBytesTopNName:
	    *var_len = strlen(currentRow->name);
	    return (unsigned char *) currentRow->name;
	case I_wwwDocBytesTopNAccesses:
	    *var_len = sizeof(currentRow->accesses);
	    return (unsigned char *) &(currentRow->accesses);
	case I_wwwDocBytesTopNBytes:
	    *var_len = sizeof(currentRow->bytes);
	    return (unsigned char *) &(currentRow->bytes);
	case I_wwwDocBytesTopNLastResponseType:
	    return (unsigned char *) &responseTypes[currentRow->lastResponseType];
        default:
            return NULL;
    }
}
#endif /* WWW_DOCUMENTS_GROUP */

static oid wwwServiceEntry_oid[] = { O_wwwServiceEntry };
static Object wwwServiceEntry_variables[] = {
    { SNMP_STRING, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceDescription }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceContact }}},
    { SNMP_OBJID, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceProtocol }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceName }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceType }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceStartTime }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceOperStatus }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwServiceEntry,
                {1, { I_wwwServiceLastChange }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwServiceEntry_tree =  { NULL, wwwServiceEntry_variables,
	        (sizeof(wwwServiceEntry_oid)/sizeof(oid)), wwwServiceEntry_oid};

static oid wwwSummaryEntry_oid[] = { O_wwwSummaryEntry };
static Object wwwSummaryEntry_variables[] = {
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryInRequests }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryOutRequests }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryInResponses }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryOutResponses }}},
    { SNMP_COUNTER64, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryInBytes }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryInLowBytes }}},
    { SNMP_COUNTER64, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryOutBytes }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwSummaryEntry,
                {1, { I_wwwSummaryOutLowBytes }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwSummaryEntry_tree =  { NULL, wwwSummaryEntry_variables,
	        (sizeof(wwwSummaryEntry_oid)/sizeof(oid)), wwwSummaryEntry_oid};

#ifdef WWW_REQUEST_IN_GROUP
static oid wwwRequestInEntry_oid[] = { O_wwwRequestInEntry };
static Object wwwRequestInEntry_variables[] = {
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwRequestInEntry,
                {1, { I_wwwRequestInRequests }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwRequestInEntry,
                {1, { I_wwwRequestInBytes }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwRequestInEntry,
                {1, { I_wwwRequestInLastTime }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwRequestInEntry_tree =  { NULL, wwwRequestInEntry_variables,
	        (sizeof(wwwRequestInEntry_oid)/sizeof(oid)), wwwRequestInEntry_oid};
#endif /* WWW_REQUEST_IN_GROUP */

#ifdef WWW_REQUEST_OUT_GROUP
static oid wwwRequestOutEntry_oid[] = { O_wwwRequestOutEntry };
static Object wwwRequestOutEntry_variables[] = {
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwRequestOutEntry,
                {1, { I_wwwRequestOutRequests }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwRequestOutEntry,
                {1, { I_wwwRequestOutBytes }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwRequestOutEntry,
                {1, { I_wwwRequestOutLastTime }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwRequestOutEntry_tree =  { NULL, wwwRequestOutEntry_variables,
	        (sizeof(wwwRequestOutEntry_oid)/sizeof(oid)), wwwRequestOutEntry_oid};
#endif /* WWW_REQUEST_OUT_GROUP */

#ifdef WWW_RESPONSE_IN_GROUP
static oid wwwResponseInEntry_oid[] = { O_wwwResponseInEntry };
static Object wwwResponseInEntry_variables[] = {
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwResponseInEntry,
                {1, { I_wwwResponseInResponses }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwResponseInEntry,
                {1, { I_wwwResponseInBytes }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwResponseInEntry,
                {1, { I_wwwResponseInLastTime }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwResponseInEntry_tree =  { NULL, wwwResponseInEntry_variables,
	        (sizeof(wwwResponseInEntry_oid)/sizeof(oid)), wwwResponseInEntry_oid};
#endif /* WWW_RESPONSE_IN_GROUP */

#ifdef WWW_RESPONSE_OUT_GROUP
static oid wwwResponseOutEntry_oid[] = { O_wwwResponseOutEntry };
static Object wwwResponseOutEntry_variables[] = {
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwResponseOutEntry,
                {1, { I_wwwResponseOutResponses }}},
    { SNMP_COUNTER, (RONLY| COLUMN), var_wwwResponseOutEntry,
                {1, { I_wwwResponseOutBytes }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwResponseOutEntry,
                {1, { I_wwwResponseOutLastTime }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwResponseOutEntry_tree =  { NULL, wwwResponseOutEntry_variables,
	        (sizeof(wwwResponseOutEntry_oid)/sizeof(oid)), wwwResponseOutEntry_oid};
#endif /* WWW_RESPONSE_OUT_GROUP */

#ifdef WWW_DOCUMENTS_GROUP
static oid wwwDocCtrlEntry_oid[] = { O_wwwDocCtrlEntry };
static Object wwwDocCtrlEntry_variables[] = {
    { SNMP_UINTEGER, (RWRITE| COLUMN), var_wwwDocCtrlEntry,
                {1, { I_wwwDocCtrlLastNSize }}},
    { SNMP_TIMETICKS, (RWRITE| COLUMN), var_wwwDocCtrlEntry,
                {1, { I_wwwDocCtrlLastNLock }}},
    { SNMP_UINTEGER, (RWRITE| COLUMN), var_wwwDocCtrlEntry,
                {1, { I_wwwDocCtrlBuckets }}},
    { SNMP_INTEGER, (RWRITE| COLUMN), var_wwwDocCtrlEntry,
                {1, { I_wwwDocCtrlBucketTimeInterval }}},
    { SNMP_UINTEGER, (RWRITE| COLUMN), var_wwwDocCtrlEntry,
                {1, { I_wwwDocCtrlTopNSize }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwDocCtrlEntry_tree =  { NULL, wwwDocCtrlEntry_variables,
	        (sizeof(wwwDocCtrlEntry_oid)/sizeof(oid)), wwwDocCtrlEntry_oid};

static oid wwwDocLastNEntry_oid[] = { O_wwwDocLastNEntry };
static Object wwwDocLastNEntry_variables[] = {
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNName }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNTimeStamp }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNRequestType }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNResponseType }}},
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNStatusMsg }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocLastNEntry,
                {1, { I_wwwDocLastNBytes }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwDocLastNEntry_tree =  { NULL, wwwDocLastNEntry_variables,
	        (sizeof(wwwDocLastNEntry_oid)/sizeof(oid)), wwwDocLastNEntry_oid};

static oid wwwDocBucketEntry_oid[] = { O_wwwDocBucketEntry };
static Object wwwDocBucketEntry_variables[] = {
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocBucketEntry,
                {1, { I_wwwDocBucketTimeStamp }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocBucketEntry,
                {1, { I_wwwDocBucketAccesses }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocBucketEntry,
                {1, { I_wwwDocBucketDocuments }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocBucketEntry,
                {1, { I_wwwDocBucketBytes }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwDocBucketEntry_tree =  { NULL, wwwDocBucketEntry_variables,
	        (sizeof(wwwDocBucketEntry_oid)/sizeof(oid)), wwwDocBucketEntry_oid};

static oid wwwDocAccessTopNEntry_oid[] = { O_wwwDocAccessTopNEntry };
static Object wwwDocAccessTopNEntry_variables[] = {
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocAccessTopNEntry,
                {1, { I_wwwDocAccessTopNName }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocAccessTopNEntry,
                {1, { I_wwwDocAccessTopNAccesses }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocAccessTopNEntry,
                {1, { I_wwwDocAccessTopNBytes }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_wwwDocAccessTopNEntry,
                {1, { I_wwwDocAccessTopNLastResponseType }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwDocAccessTopNEntry_tree =  { NULL, wwwDocAccessTopNEntry_variables,
	        (sizeof(wwwDocAccessTopNEntry_oid)/sizeof(oid)), wwwDocAccessTopNEntry_oid};

static oid wwwDocBytesTopNEntry_oid[] = { O_wwwDocBytesTopNEntry };
static Object wwwDocBytesTopNEntry_variables[] = {
    { SNMP_STRING, (RONLY| COLUMN), var_wwwDocBytesTopNEntry,
                {1, { I_wwwDocBytesTopNName }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocBytesTopNEntry,
                {1, { I_wwwDocBytesTopNAccesses }}},
    { SNMP_UINTEGER, (RONLY| COLUMN), var_wwwDocBytesTopNEntry,
                {1, { I_wwwDocBytesTopNBytes }}},
    { SNMP_INTEGER, (RONLY| COLUMN), var_wwwDocBytesTopNEntry,
                {1, { I_wwwDocBytesTopNLastResponseType }}},
    { 0, 0, NULL, {0, {0}}}
    };
static SubTree wwwDocBytesTopNEntry_tree =  { NULL, wwwDocBytesTopNEntry_variables,
	        (sizeof(wwwDocBytesTopNEntry_oid)/sizeof(oid)), wwwDocBytesTopNEntry_oid};
#endif /* WWW_DOCUMENTS_GROUP */

/* This is the MIB registration function. This should be called */
/* within the init_WWW_MIB-function */
void register_subtrees_of_WWW_MIB()
{
    insert_group_in_mib(&wwwServiceEntry_tree);
    insert_group_in_mib(&wwwSummaryEntry_tree);
#ifdef WWW_REQUEST_IN_GROUP
    insert_group_in_mib(&wwwRequestInEntry_tree);
#endif
#ifdef WWW_REQUEST_OUT_GROUP
    insert_group_in_mib(&wwwRequestOutEntry_tree);
#endif
#ifdef WWW_RESPONSE_IN_GROUP
    insert_group_in_mib(&wwwResponseInEntry_tree);
#endif
#ifdef WWW_RESPONSE_OUT_GROUP
    insert_group_in_mib(&wwwResponseOutEntry_tree);
#endif
#ifdef WWW_DOCUMENTS_GROUP
    insert_group_in_mib(&wwwDocCtrlEntry_tree);
    insert_group_in_mib(&wwwDocLastNEntry_tree);
    insert_group_in_mib(&wwwDocBucketEntry_tree);
    insert_group_in_mib(&wwwDocAccessTopNEntry_tree);
    insert_group_in_mib(&wwwDocBytesTopNEntry_tree);
#endif
}
