/* ====================================================================
 * Copyright (c) 1997-2000 Harrie Hazewinkel.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Harrie Hazewinkel."
 *
 * 4. The name of the Copyright holder must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "MOD-SNMP"
 *    nor may "MOD-SNMP" appear in their names  without prior written
 *    permission of the Harrie Hazewinkel.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Harrie Hazewinkel"
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * The creator of this module is Harrie.Hazewinkel@bigfoot.com
 * This file contains generated code of SMASH also created by Harrie.
 *
 *
 */
#ifndef	_WWW_MIB_
#define	_WWW_MIB_

/* required include files (IMPORTS) */
#include	"snmpv2-conf.h"
#include	"snmpv2-tc.h"
#include	"snmpv2-smi.h"


void init_WWW_MIB();
void register_subtrees_of_WWW_MIB();

/* defined objects in this module */

/* MIB object wwwMIB = mib_2, 65 */
#define	I_wwwMIB	65
#define	O_wwwMIB	1, 3, 6, 1, 2, 1, 65

/* MIB object wwwMIBObjects = wwwMIB, 1 */
#define	I_wwwMIBObjects	1
#define	O_wwwMIBObjects	1, 3, 6, 1, 2, 1, 65, 1

/* MIB object wwwMIBConformance = wwwMIB, 2 */
#define	I_wwwMIBConformance	2
#define	O_wwwMIBConformance	1, 3, 6, 1, 2, 1, 65, 2

/* MIB object wwwService = wwwMIBObjects, 1 */
#define	I_wwwService	1
#define	O_wwwService	1, 3, 6, 1, 2, 1, 65, 1, 1

/* MIB object wwwServiceTable = wwwService, 1 */
#define	I_wwwServiceTable	1
#define	O_wwwServiceTable	1, 3, 6, 1, 2, 1, 65, 1, 1, 1

/* MIB object wwwServiceEntry = wwwServiceTable, 1 */
#define	I_wwwServiceEntry	1
#define	O_wwwServiceEntry	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1

/* MIB object wwwServiceIndex = wwwServiceEntry, 1 */
#define	I_wwwServiceIndex	1
#define	O_wwwServiceIndex	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 1

/* MIB object wwwServiceDescription = wwwServiceEntry, 2 */
#define	I_wwwServiceDescription	2
#define	O_wwwServiceDescription	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 2

/* MIB object wwwServiceContact = wwwServiceEntry, 3 */
#define	I_wwwServiceContact	3
#define	O_wwwServiceContact	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 3

/* MIB object wwwServiceProtocol = wwwServiceEntry, 4 */
#define	I_wwwServiceProtocol	4
#define	O_wwwServiceProtocol	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 4

/* MIB object wwwServiceName = wwwServiceEntry, 5 */
#define	I_wwwServiceName	5
#define	O_wwwServiceName	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 5

/* MIB object wwwServiceType = wwwServiceEntry, 6 */
#define	I_wwwServiceType	6
#define	O_wwwServiceType	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 6

/* MIB object wwwServiceStartTime = wwwServiceEntry, 7 */
#define	I_wwwServiceStartTime	7
#define	O_wwwServiceStartTime	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 7

/* MIB object wwwServiceOperStatus = wwwServiceEntry, 8 */
#define	I_wwwServiceOperStatus	8
#define	O_wwwServiceOperStatus	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 8

/* enumerated wwwServiceOperStatus */
#define VHOST_DOWN		1
#define VHOST_RUNNING		2
#define VHOST_HALTED		3
#define VHOST_CONGESTED		4
#define VHOST_RESTARTING	5

/* MIB object wwwServiceLastChange = wwwServiceEntry, 9 */
#define	I_wwwServiceLastChange	9
#define	O_wwwServiceLastChange	1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 9

/* MIB object wwwProtocolStatistics = wwwMIBObjects, 2 */
#define	I_wwwProtocolStatistics	2
#define	O_wwwProtocolStatistics	1, 3, 6, 1, 2, 1, 65, 1, 2

/* MIB object wwwSummaryTable = wwwProtocolStatistics, 1 */
#define	I_wwwSummaryTable	1
#define	O_wwwSummaryTable	1, 3, 6, 1, 2, 1, 65, 1, 2, 1

/* MIB object wwwSummaryEntry = wwwSummaryTable, 1 */
#define	I_wwwSummaryEntry	1
#define	O_wwwSummaryEntry	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1

/* MIB object wwwSummaryInRequests = wwwSummaryEntry, 1 */
#define	I_wwwSummaryInRequests	1
#define	O_wwwSummaryInRequests	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 1

/* MIB object wwwSummaryOutRequests = wwwSummaryEntry, 2 */
#define	I_wwwSummaryOutRequests	2
#define	O_wwwSummaryOutRequests	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 2

/* MIB object wwwSummaryInResponses = wwwSummaryEntry, 3 */
#define	I_wwwSummaryInResponses	3
#define	O_wwwSummaryInResponses	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 3

/* MIB object wwwSummaryOutResponses = wwwSummaryEntry, 4 */
#define	I_wwwSummaryOutResponses	4
#define	O_wwwSummaryOutResponses	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 4

/* MIB object wwwSummaryInBytes = wwwSummaryEntry, 5 */
#define	I_wwwSummaryInBytes	5
#define	O_wwwSummaryInBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 5

/* MIB object wwwSummaryInLowBytes = wwwSummaryEntry, 6 */
#define	I_wwwSummaryInLowBytes	6
#define	O_wwwSummaryInLowBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 6

/* MIB object wwwSummaryOutBytes = wwwSummaryEntry, 7 */
#define	I_wwwSummaryOutBytes	7
#define	O_wwwSummaryOutBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 7

/* MIB object wwwSummaryOutLowBytes = wwwSummaryEntry, 8 */
#define	I_wwwSummaryOutLowBytes	8
#define	O_wwwSummaryOutLowBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 8

/* MIB object wwwRequestInTable = wwwProtocolStatistics, 2 */
#define	I_wwwRequestInTable	2
#define	O_wwwRequestInTable	1, 3, 6, 1, 2, 1, 65, 1, 2, 2

/* MIB object wwwRequestInEntry = wwwRequestInTable, 1 */
#define	I_wwwRequestInEntry	1
#define	O_wwwRequestInEntry	1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1

/* MIB object wwwRequestInIndex = wwwRequestInEntry, 1 */
#define	I_wwwRequestInIndex	1
#define	O_wwwRequestInIndex	1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 1

/* MIB object wwwRequestInRequests = wwwRequestInEntry, 2 */
#define	I_wwwRequestInRequests	2
#define	O_wwwRequestInRequests	1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 2

/* MIB object wwwRequestInBytes = wwwRequestInEntry, 3 */
#define	I_wwwRequestInBytes	3
#define	O_wwwRequestInBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 3

/* MIB object wwwRequestInLastTime = wwwRequestInEntry, 4 */
#define	I_wwwRequestInLastTime	4
#define	O_wwwRequestInLastTime	1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 4

/* MIB object wwwRequestOutTable = wwwProtocolStatistics, 3 */
#define	I_wwwRequestOutTable	3
#define	O_wwwRequestOutTable	1, 3, 6, 1, 2, 1, 65, 1, 2, 3

/* MIB object wwwRequestOutEntry = wwwRequestOutTable, 1 */
#define	I_wwwRequestOutEntry	1
#define	O_wwwRequestOutEntry	1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1

/* MIB object wwwRequestOutIndex = wwwRequestOutEntry, 1 */
#define	I_wwwRequestOutIndex	1
#define	O_wwwRequestOutIndex	1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 1

/* MIB object wwwRequestOutRequests = wwwRequestOutEntry, 2 */
#define	I_wwwRequestOutRequests	2
#define	O_wwwRequestOutRequests	1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 2

/* MIB object wwwRequestOutBytes = wwwRequestOutEntry, 3 */
#define	I_wwwRequestOutBytes	3
#define	O_wwwRequestOutBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 3

/* MIB object wwwRequestOutLastTime = wwwRequestOutEntry, 4 */
#define	I_wwwRequestOutLastTime	4
#define	O_wwwRequestOutLastTime	1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 4

/* MIB object wwwResponseInTable = wwwProtocolStatistics, 4 */
#define	I_wwwResponseInTable	4
#define	O_wwwResponseInTable	1, 3, 6, 1, 2, 1, 65, 1, 2, 4

/* MIB object wwwResponseInEntry = wwwResponseInTable, 1 */
#define	I_wwwResponseInEntry	1
#define	O_wwwResponseInEntry	1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1

/* MIB object wwwResponseInIndex = wwwResponseInEntry, 1 */
#define	I_wwwResponseInIndex	1
#define	O_wwwResponseInIndex	1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 1

/* MIB object wwwResponseInResponses = wwwResponseInEntry, 2 */
#define	I_wwwResponseInResponses	2
#define	O_wwwResponseInResponses	1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 2

/* MIB object wwwResponseInBytes = wwwResponseInEntry, 3 */
#define	I_wwwResponseInBytes	3
#define	O_wwwResponseInBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 3

/* MIB object wwwResponseInLastTime = wwwResponseInEntry, 4 */
#define	I_wwwResponseInLastTime	4
#define	O_wwwResponseInLastTime	1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 4

/* MIB object wwwResponseOutTable = wwwProtocolStatistics, 5 */
#define	I_wwwResponseOutTable	5
#define	O_wwwResponseOutTable	1, 3, 6, 1, 2, 1, 65, 1, 2, 5

/* MIB object wwwResponseOutEntry = wwwResponseOutTable, 1 */
#define	I_wwwResponseOutEntry	1
#define	O_wwwResponseOutEntry	1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1

/* MIB object wwwResponseOutIndex = wwwResponseOutEntry, 1 */
#define	I_wwwResponseOutIndex	1
#define	O_wwwResponseOutIndex	1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 1

/* MIB object wwwResponseOutResponses = wwwResponseOutEntry, 2 */
#define	I_wwwResponseOutResponses	2
#define	O_wwwResponseOutResponses	1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 2

/* MIB object wwwResponseOutBytes = wwwResponseOutEntry, 3 */
#define	I_wwwResponseOutBytes	3
#define	O_wwwResponseOutBytes	1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 3

/* MIB object wwwResponseOutLastTime = wwwResponseOutEntry, 4 */
#define	I_wwwResponseOutLastTime	4
#define	O_wwwResponseOutLastTime	1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 4

/* MIB object wwwDocumentStatistics = wwwMIBObjects, 3 */
#define	I_wwwDocumentStatistics	3
#define	O_wwwDocumentStatistics	1, 3, 6, 1, 2, 1, 65, 1, 3

/* MIB object wwwDocCtrlTable = wwwDocumentStatistics, 1 */
#define	I_wwwDocCtrlTable	1
#define	O_wwwDocCtrlTable	1, 3, 6, 1, 2, 1, 65, 1, 3, 1

/* MIB object wwwDocCtrlEntry = wwwDocCtrlTable, 1 */
#define	I_wwwDocCtrlEntry	1
#define	O_wwwDocCtrlEntry	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1

/* MIB object wwwDocCtrlLastNSize = wwwDocCtrlEntry, 1 */
#define	I_wwwDocCtrlLastNSize	1
#define	O_wwwDocCtrlLastNSize	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 1

/* MIB object wwwDocCtrlLastNLock = wwwDocCtrlEntry, 2 */
#define	I_wwwDocCtrlLastNLock	2
#define	O_wwwDocCtrlLastNLock	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 2

/* MIB object wwwDocCtrlBuckets = wwwDocCtrlEntry, 3 */
#define	I_wwwDocCtrlBuckets	3
#define	O_wwwDocCtrlBuckets	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 3

/* MIB object wwwDocCtrlBucketTimeInterval = wwwDocCtrlEntry, 4 */
#define	I_wwwDocCtrlBucketTimeInterval	4
#define	O_wwwDocCtrlBucketTimeInterval	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 4

/* MIB object wwwDocCtrlTopNSize = wwwDocCtrlEntry, 5 */
#define	I_wwwDocCtrlTopNSize	5
#define	O_wwwDocCtrlTopNSize	1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 5

/* MIB object wwwDocLastNTable = wwwDocumentStatistics, 2 */
#define	I_wwwDocLastNTable	2
#define	O_wwwDocLastNTable	1, 3, 6, 1, 2, 1, 65, 1, 3, 2

/* MIB object wwwDocLastNEntry = wwwDocLastNTable, 1 */
#define	I_wwwDocLastNEntry	1
#define	O_wwwDocLastNEntry	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1

/* MIB object wwwDocLastNIndex = wwwDocLastNEntry, 1 */
#define	I_wwwDocLastNIndex	1
#define	O_wwwDocLastNIndex	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 1

/* MIB object wwwDocLastNName = wwwDocLastNEntry, 2 */
#define	I_wwwDocLastNName	2
#define	O_wwwDocLastNName	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 2

/* MIB object wwwDocLastNTimeStamp = wwwDocLastNEntry, 3 */
#define	I_wwwDocLastNTimeStamp	3
#define	O_wwwDocLastNTimeStamp	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 3

/* MIB object wwwDocLastNRequestType = wwwDocLastNEntry, 4 */
#define	I_wwwDocLastNRequestType	4
#define	O_wwwDocLastNRequestType	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 4

/* MIB object wwwDocLastNResponseType = wwwDocLastNEntry, 5 */
#define	I_wwwDocLastNResponseType	5
#define	O_wwwDocLastNResponseType	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 5

/* MIB object wwwDocLastNStatusMsg = wwwDocLastNEntry, 6 */
#define	I_wwwDocLastNStatusMsg	6
#define	O_wwwDocLastNStatusMsg	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 6

/* MIB object wwwDocLastNBytes = wwwDocLastNEntry, 7 */
#define	I_wwwDocLastNBytes	7
#define	O_wwwDocLastNBytes	1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 7

/* MIB object wwwDocBucketTable = wwwDocumentStatistics, 3 */
#define	I_wwwDocBucketTable	3
#define	O_wwwDocBucketTable	1, 3, 6, 1, 2, 1, 65, 1, 3, 3

/* MIB object wwwDocBucketEntry = wwwDocBucketTable, 1 */
#define	I_wwwDocBucketEntry	1
#define	O_wwwDocBucketEntry	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1

/* MIB object wwwDocBucketIndex = wwwDocBucketEntry, 1 */
#define	I_wwwDocBucketIndex	1
#define	O_wwwDocBucketIndex	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 1

/* MIB object wwwDocBucketTimeStamp = wwwDocBucketEntry, 2 */
#define	I_wwwDocBucketTimeStamp	2
#define	O_wwwDocBucketTimeStamp	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 2

/* MIB object wwwDocBucketAccesses = wwwDocBucketEntry, 3 */
#define	I_wwwDocBucketAccesses	3
#define	O_wwwDocBucketAccesses	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 3

/* MIB object wwwDocBucketDocuments = wwwDocBucketEntry, 4 */
#define	I_wwwDocBucketDocuments	4
#define	O_wwwDocBucketDocuments	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 4

/* MIB object wwwDocBucketBytes = wwwDocBucketEntry, 5 */
#define	I_wwwDocBucketBytes	5
#define	O_wwwDocBucketBytes	1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 5

/* MIB object wwwDocAccessTopNTable = wwwDocumentStatistics, 4 */
#define	I_wwwDocAccessTopNTable	4
#define	O_wwwDocAccessTopNTable	1, 3, 6, 1, 2, 1, 65, 1, 3, 4

/* MIB object wwwDocAccessTopNEntry = wwwDocAccessTopNTable, 1 */
#define	I_wwwDocAccessTopNEntry	1
#define	O_wwwDocAccessTopNEntry	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1

/* MIB object wwwDocAccessTopNIndex = wwwDocAccessTopNEntry, 1 */
#define	I_wwwDocAccessTopNIndex	1
#define	O_wwwDocAccessTopNIndex	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 1

/* MIB object wwwDocAccessTopNName = wwwDocAccessTopNEntry, 2 */
#define	I_wwwDocAccessTopNName	2
#define	O_wwwDocAccessTopNName	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 2

/* MIB object wwwDocAccessTopNAccesses = wwwDocAccessTopNEntry, 3 */
#define	I_wwwDocAccessTopNAccesses	3
#define	O_wwwDocAccessTopNAccesses	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 3

/* MIB object wwwDocAccessTopNBytes = wwwDocAccessTopNEntry, 4 */
#define	I_wwwDocAccessTopNBytes	4
#define	O_wwwDocAccessTopNBytes	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 4

/* MIB object wwwDocAccessTopNLastResponseType = wwwDocAccessTopNEntry, 5 */
#define	I_wwwDocAccessTopNLastResponseType	5
#define	O_wwwDocAccessTopNLastResponseType	1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 5

/* MIB object wwwDocBytesTopNTable = wwwDocumentStatistics, 5 */
#define	I_wwwDocBytesTopNTable	5
#define	O_wwwDocBytesTopNTable	1, 3, 6, 1, 2, 1, 65, 1, 3, 5

/* MIB object wwwDocBytesTopNEntry = wwwDocBytesTopNTable, 1 */
#define	I_wwwDocBytesTopNEntry	1
#define	O_wwwDocBytesTopNEntry	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1

/* MIB object wwwDocBytesTopNIndex = wwwDocBytesTopNEntry, 1 */
#define	I_wwwDocBytesTopNIndex	1
#define	O_wwwDocBytesTopNIndex	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 1

/* MIB object wwwDocBytesTopNName = wwwDocBytesTopNEntry, 2 */
#define	I_wwwDocBytesTopNName	2
#define	O_wwwDocBytesTopNName	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 2

/* MIB object wwwDocBytesTopNAccesses = wwwDocBytesTopNEntry, 3 */
#define	I_wwwDocBytesTopNAccesses	3
#define	O_wwwDocBytesTopNAccesses	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 3

/* MIB object wwwDocBytesTopNBytes = wwwDocBytesTopNEntry, 4 */
#define	I_wwwDocBytesTopNBytes	4
#define	O_wwwDocBytesTopNBytes	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 4

/* MIB object wwwDocBytesTopNLastResponseType = wwwDocBytesTopNEntry, 5 */
#define	I_wwwDocBytesTopNLastResponseType	5
#define	O_wwwDocBytesTopNLastResponseType	1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 5

/* MIB object wwwMIBCompliances = wwwMIBConformance, 1 */
#define	I_wwwMIBCompliances	1
#define	O_wwwMIBCompliances	1, 3, 6, 1, 2, 1, 65, 2, 1

/* MIB object wwwMIBGroups = wwwMIBConformance, 2 */
#define	I_wwwMIBGroups	2
#define	O_wwwMIBGroups	1, 3, 6, 1, 2, 1, 65, 2, 2

/* MIB object wwwMinimalCompliance = wwwMIBCompliances, 1 */
#define	I_wwwMinimalCompliance	1
#define	O_wwwMinimalCompliance	1, 3, 6, 1, 2, 1, 65, 2, 1, 1

/* MIB object wwwFullCompliance = wwwMIBCompliances, 2 */
#define	I_wwwFullCompliance	2
#define	O_wwwFullCompliance	1, 3, 6, 1, 2, 1, 65, 2, 1, 2

/* MIB object wwwServiceGroup = wwwMIBGroups, 1 */
#define	I_wwwServiceGroup	1
#define	O_wwwServiceGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 1

/* MIB object wwwSummaryGroup = wwwMIBGroups, 2 */
#define	I_wwwSummaryGroup	2
#define	O_wwwSummaryGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 2

/* MIB object wwwRequestInGroup = wwwMIBGroups, 3 */
#define	I_wwwRequestInGroup	3
#define	O_wwwRequestInGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 3

/* MIB object wwwRequestOutGroup = wwwMIBGroups, 4 */
#define	I_wwwRequestOutGroup	4
#define	O_wwwRequestOutGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 4

/* MIB object wwwResponseInGroup = wwwMIBGroups, 5 */
#define	I_wwwResponseInGroup	5
#define	O_wwwResponseInGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 5

/* MIB object wwwResponseOutGroup = wwwMIBGroups, 6 */
#define	I_wwwResponseOutGroup	6
#define	O_wwwResponseOutGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 6

/* MIB object wwwDocumentGroup = wwwMIBGroups, 7 */
#define	I_wwwDocumentGroup	7
#define	O_wwwDocumentGroup	1, 3, 6, 1, 2, 1, 65, 2, 2, 7

#ifdef WWWFULLCOMPLIANCE
#define WWW_REQUEST_IN_GROUP
#define WWW_REQUEST_OUT_GROUP
#define WWW_RESPONSE_IN_GROUP
#define WWW_RESPONSE_OUT_GROUP
#define WWW_DOCUMENT_GROUP
#endif

void init_wwwServiceOperStatus();

#endif	/* _WWW_MIB_ */
