#!/bin/sh
#(c) 2004 Robert Shingledecker for the Damnsmall Linux Project
#29 Aug 2004 - May 2005
#
. /etc/init.d/dsl-functions
#
MIRROR=$(dslrc.lua Mirror) || MIRROR="ibiblio.org/pub/Linux/distributions/damnsmall/"
PROTOCOL=$(dslrc.lua Protocol) || PROTOCOL="http"
export PATH="$PATH:."
clear
echo
echo "${RED}DSL USB pendrive ${WHITE}installation/upgrade for USB-ZIP booting ${BLUE}utility.${NORMAL}"
echo
echo "If this is a new installation then:"
echo "1. Your pendrive must be at least 64MB in size."
echo "2. Your pendrive will be formatted into two partitions."
echo "3. One small one for USB_ZIP boot compatibility, and used to hold DSL."
echo "4. The remaining partition will be used for backup & extensions."
echo
echo "${CYAN}DO NOT have your pendrive mounted.${NORMAL}"
echo
echo "${YELLOW}No responsibility for data loss or hardware damage!${NORMAL}"
echo
echo -n "${CYAN}Ready to proceed with USB-ZIP boot install/upgrade. (y/..)?${NORMAL} "
read answer
if [ "$answer" != "y" ]; then
   echo "Aborted.."
   echo -n "Press Enter key to continue."; read gagme
   exit 1
fi

INSTALLTYPE=""
until [ "$INSTALLTYPE" == "i" ] || [ "$INSTALLTYPE" == "u" ]; do
   echo -n "${CYAN}Is this an installation or upgrade? ${NORMAL}(i/u)? "
   read INSTALLTYPE
done

if [ ! -f bootfloppy-usb.img ]; then
   echo "${BLUE}Standby fetching the bootusb image file...${NORMAL}"
   wget -q "$PROTOCOL"://"$MIRROR"/current/bootfloppy-usb.img.md5.txt
   wget "$PROTOCOL"://"$MIRROR"/current/bootfloppy-usb.img
   if [ $? != 0 ]; then
      echo "${RED}Error while trying to fetch the bootusb image file.${NORMAL}"
      rm -f bootfloppy-usb.img
      echo "Script is terminating..."
      echo -n "Press Enter key to continue."; read gagme
      exit 1
   fi
    md5sum -c bootfloppy-usb.img.md5.txt
    if [ $? != 0 ]; then
      echo "${RED}Checksum error in downloaded file"
      echo "The script is terminating...${NORMAL}"
      echo -n "Press Enter key to continue."; read gagme
      exit 1
    fi
fi
# read target partition from user
echo -n "${CYAN}Enter the target device to hold image ${WHITE}(EXAMPLE: ${YELLOW}sda): ${NORMAL}" 
read DEVICE
if [ -z "$DEVICE" ] ; then
  echo "No device chosen. The script will be terminated."
  echo -n "Press Enter key to continue."; read gagme
  exit 1
fi    
USB="$DEVICE"1
#

echo -n "${CYAN}Use DSL iso from [L]iveCD, from [F]ile, from [W]eb.${YELLOW} (l/f/w): ${NORMAL}"
read INSTALL
case "$INSTALL" in 
  "L" | "l")
    SOURCE="/cdrom"
    IMAGE="/cdrom"
  ;;   
  "F" | "f")
    # read path from user                                               
    echo -n "${CYAN}Enter the full path to the iso.  ${WHITE}(EXAMPLE: ${YELLOW}/home/dsl/dsl-1.0.1.iso): ${NORMAL}"
    read SOURCE
    if [ -z "$SOURCE" ] ; then
      echo "No path entered. The script will be terminated."
      echo -n "Press Enter key to continue."; read gagme
      exit 0
    fi          
  ;;  
  "W" | "w")
    # fetch ISO from web.
    echo "${BLUE}Standby fetching ISO.${NORMAL}"
    wget -q "$PROTOCOL"://"$MIRROR"/current/current.iso.md5.txt
    wget "$PROTOCOL"://"$MIRROR"/current/current.iso
    if [ $? != 0 ]; then
      rm -f current.iso
      echo "${RED}Sorry the iso image file could not be retrieved or does not fit"
      echo "on your ramdisk.  The script is terminating...${NORMAL}"
      echo -n "Press Enter key to continue."; read gagme
      exit 1
    fi
    md5sum -c current.iso.md5.txt
    if [ $? != 0 ]; then
      echo "${RED}Checksum error in downloaded file"
      echo "The script is terminating...${NORMAL}"
      echo -n "Press Enter key to continue."; read gagme
      exit 1
    fi

    SOURCE="current.iso"
  ;;  
esac  

if [ "$SOURCE" != "/cdrom" ]; then
  # We need to mount the ISO file using the loopback driver.
  # Start by creating a mount point directory; we'll call it "staging"
  mkdir /mnt/staging
  mount -t iso9660 -o loop,ro $SOURCE /mnt/staging
  if [ $? != 0 ]; then
    umount /mnt/pendrive  # unmount the target drive 
    echo "${RED}Sorry $SOURCE not found!"
    echo "Installation not successful!${NORMAL}"
    echo -n "Press Enter key to continue."; read gagme
    exit 1
  fi  
  IMAGE="/mnt/staging"
fi

#
echo "${CYAN}Enter optional boot time options: "
echo -n "${WHITE}Example: ${YELLOW}vga=normal toram ssh nfs syslog lpd monkey ftp${NORMAL}: "
read DAEMONS

echo "${CYAN}Choose language/keyboard if other than english, "
echo -n "${WHITE}Example: ${YELLOW}cs da de es fr nl it pl ru sk${NORMAL}: "
read LANG
if [ ! -z "$LANG" ]; then
   LANG="lang=$LANG"
fi
#
if [ "$INSTALLTYPE" == "i" ] ; then
   echo "${RED}Last change to exit before destroying all data on ${MAGENTA}/dev/$DEVICE${NORMAL}"
   echo -n "${CYAN}Continue (y/..)?${NORMAL} "
   read answer
   if [ "$answer" != "y" ]; then
     echo "Aborted.."
     echo -n "Press Enter key to continue."; read gagme
     exit 0
   fi
   echo
   echo "${BLUE}Changing geometry for USB-ZIP compatibility on ${MAGENTA}/dev/$DEVICE${NORMAL}"
   mkdiskimage -1 /dev/$DEVICE 50 64 32
   if [ $? != 0 ]; then
      echo "Error creating USB-ZIP compatible filesystem."
      echo -n "Press Enter key to continue."; read gagme
      exit 1
   fi
# Use remaining pendrive for backup/restore and mydsl
#
   DATA="$DEVICE"2
   echo "${BLUE}Partitioning ${MAGENTA}/dev/$DEVICE${NORMAL}"
   fdisk /dev/$DEVICE << EOF >/dev/null 2>&1
n
p
2


t
2
b
w
EOF
   sync
   hdparm -z /dev/$DEVICE
   echo "${BLUE}Formatting ${MAGENTA}/dev/$DATA${NORMAL}"
   mkdosfs /dev/$DATA >/dev/null 2>&1
   sync
#
   echo "${BLUE}Formatting ${MAGENTA}/dev/$USB${NORMAL}"
   mkdosfs /dev/$USB
   if [ $? != 0 ]; then
      echo "Error while formatting DOS filesystem."
      echo -n "Press Enter key to continue."; read gagme
      exit 1
   fi
   sync
   echo "${BLUE}Setting up boot loader on ${MAGENTA}/mnt/$USB${NORMAL}"
   syslinux  /dev/$USB
   if [ $? != 0 ]; then
      echo "Error writing boot sector"
      echo -n "Press Enter key to continue."; read gagme
      exit 1
   fi
   sync
fi  # End installation specific code

mkdir boot
mount bootfloppy-usb.img boot -t vfat -o loop

echo "${BLUE}Setting up boot image on ${MAGENTA}/mnt/$USB${NORMAL}"
mkdir /mnt/pendrive
mount -t vfat /dev/$USB /mnt/pendrive
if [ $? != 0 ]; then
   echo "Error mounting usb device"
   echo -n "Press Enter key to continue."; read gagme
   exit 1
fi
cp  boot/* /mnt/pendrive
echo -n "${BLUE}Setting up system image on ${MAGENTA}/mnt/$USB${NORMAL}..."
cp -r $IMAGE/KNOPPIX /mnt/pendrive &
rotdash $!
sync
sed -i s"/frugal/frugal restore=$DATA mydsl=$DATA $DAEMONS $LANG/" /mnt/pendrive/syslinux.cfg
sync
echo " Done."
umount boot /mnt/pendrive
echo "${GREEN}USB installation has completed${NORMAL}"
echo -n "Press Enter key to continue."; read gagme
